from telegram import Update
from telegram.ext import ContextTypes, ConversationHandler

from handlers.withdraw.hawala_withdraw import (
    admin_approve_hawala,
    admin_reject_hawala,
    receive_hawala_proof
)
from constants import AWAITING_HAWALA_PROOF


# ===== كولباكات الأدمن =====
async def admin_callback_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    data = query.data

    # موافقة الحوالة
    if data.startswith("hawala_approve:"):
        return await admin_approve_hawala(update, context)

    # رفض الحوالة
    elif data.startswith("hawala_reject:"):
        return await admin_reject_hawala(update, context)

    else:
        await query.answer("❌ أمر غير معروف.")
        return ConversationHandler.END


# ===== استقبال صورة الإشعار من الأدمن =====
async def admin_receive_proof_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    """يستقبل صورة الحوالة من الأدمن بعد الموافقة"""
    if update.message.photo:
        return await receive_hawala_proof(update, context)
    else:
        await update.message.reply_text("❌ الرجاء إرسال صورة الإشعار (وليس نصاً).")
        return AWAITING_HAWALA_PROOF
