# handlers/admin/admin_menu.py

from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes , ConversationHandler
from config import ADMIN_IDS

from config import DEPOSIT_INFO
async def go_back_to_admin_panel(update: Update, context: ContextTypes.DEFAULT_TYPE) -> int:

    query = update.callback_query
    await query.answer()
    await admin_panel_handler(update, context)
    return ConversationHandler.END


async def admin_panel_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    await query.answer()

    keyboard = [
    # 🌟 الصف الأول: الإحصائيات والإدارة العامة 🌟
    [
        InlineKeyboardButton("📈 الإحصائيات", callback_data="admin_stats"),
        InlineKeyboardButton("📢 رسالة جماعية", callback_data="broadcast_message"),
        InlineKeyboardButton("🛠️ حساب الدعم", callback_data="set_support_account"),
    ],
    
    # 💰 الصف الثاني: إدارة الأموال والسحب 💰
    [
        InlineKeyboardButton("💸 طلبات السحب المعلقة", callback_data="pending_withdrawals"),
        InlineKeyboardButton("🟡 طلبات الإيداع المعلقة", callback_data="pending_deposits")
    ],
    
    # ⚙️ الصف الثالث: الإعدادات المالية والنسب ⚙️
    [
        InlineKeyboardButton("💱 تحديث سعر الصرف", callback_data="set_exchange_rate"),
        InlineKeyboardButton("⚙️ إدارة النسب", callback_data="manage_rates"),
        InlineKeyboardButton("👥 نسب الإحالات", callback_data="edit_referral_percentages"),
    ],
    
    # 🎁 الصف الرابع: العروض والبونصات 🎁
    [
        InlineKeyboardButton("🎁 العروض والبونصات", callback_data="promo_codes_menu"),
        InlineKeyboardButton("🎯 توزيع أرباح الإحالة يدوياً", callback_data="manual_referral_distribution")
    ],
    [
        InlineKeyboardButton("💳 إدارة أرقام سيرياتيل", callback_data="manage_syriatel_numbers"),
    ],

    [
        InlineKeyboardButton("🔒 إدارة عمليات الإيداع ", callback_data="manage_deposits"),
    ],
    # 👤 الصف الخامس: إدارة المستخدمين والسجلات 👤
    [
        InlineKeyboardButton("👥 إدارة المستخدمين", callback_data="users_page:0"),
        InlineKeyboardButton("📄 كل العمليات", callback_data="show_all_transactions"),
    ],
    [
        InlineKeyboardButton("💰 رصيد شام كاش", callback_data="show_chamcash_balance"),
    ],
    [
        InlineKeyboardButton("🟢 تشغيل/إيقاف البوت", callback_data="toggle_bot_status"),
        InlineKeyboardButton("🔄 تشغيل/إيقاف الشحن والسحب", callback_data="toggle_deposit_withdraw")

    ],
    

    
    # ↩️ العودة للقائمة الرئيسية ↩️
    [
        InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")
    ]
]
    reply_markup = InlineKeyboardMarkup(keyboard)
    await query.edit_message_text(
        "⚙️ **لوحة الأدمن - التحكم الكامل**\n\n"
        "اختر القسم الذي تريد التعامل معه 👇",
        reply_markup=reply_markup,
        parse_mode="Markdown"
    )


async def promo_codes_menu(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    keyboard = [
        [InlineKeyboardButton("➕ إضافة كود هدية", callback_data="add_promo_code")],
        [InlineKeyboardButton("✏️ تعديل كود", callback_data="edit_promo_code")],
        [InlineKeyboardButton("🗑️ حذف كود", callback_data="delete_promo_code")],
        [InlineKeyboardButton("📋 عرض جميع الأكواد", callback_data="list_promo_codes")],
        [InlineKeyboardButton("📢 نشر الأكواد", callback_data="publish_promo_codes")],
        [InlineKeyboardButton("🔙 العودة للوحة الأدمن", callback_data="admin_panel")]
    ]
    reply_markup = InlineKeyboardMarkup(keyboard)
    await query.edit_message_text("🎁 إدارة العروض والبونصات:", reply_markup=reply_markup)


def escape_markdown(text: str) -> str:
    import re
    """Escape Markdown special characters"""
    if not text:
        return ""
    escape_chars = r'_*[]()~`>#+-=|{}.!'
    return re.sub(f"([{re.escape(escape_chars)}])", r"\\\1", str(text))


async def toggle_bot_status(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import get_bot_status, set_bot_status
    query = update.callback_query
    await query.answer()

    current_status = get_bot_status()
    new_status = "stopped" if current_status == "running" else "running"
    set_bot_status(new_status)

    text = "✅ تم **تشغيل البوت** بنجاح." if new_status == "running" else "⛔ تم **إيقاف البوت مؤقتًا**."
    
    await query.edit_message_text(
        f"{text}\n\n🔄 الحالة الحالية: `{new_status}`",
        parse_mode="Markdown"
    )
    
    import asyncio
    await asyncio.sleep(0.5)
    
    # استدعاء دالة لوحة الأدمن
    from handlers.admin.admin_menu import admin_panel_handler
    await admin_panel_handler(update, context)
async def toggle_deposit_withdraw(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import toggle_deposit_withdraw

    query = update.callback_query
    await query.answer()

    # تشغيل الوظيفة الجديدة
    new_status = toggle_deposit_withdraw()

    # نص الرسالة حسب الحالة
    status_text = "✅ تم **تفعيل الشحن والسحب**." if new_status else "⛔ تم **إيقاف الشحن والسحب مؤقتًا**."

    await query.edit_message_text(
        f"{status_text}\n\n🔄 الحالة الحالية: `{'مفعل' if new_status else 'معطل'}`",
        parse_mode="Markdown"
    )

    import asyncio
    await asyncio.sleep(0.5)
    
    # استدعاء دالة لوحة الأدمن
    from handlers.admin.admin_menu import admin_panel_handler
    await admin_panel_handler(update, context)
     
async def manual_referral_distribution(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from database import get_last_referral_distribution
    """عرض خيارات توزيع الأرباح يدوياً"""
    query = update.callback_query
    await query.answer()
    
    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return
    
    # إحصائيات سريعة
    try:
        from database import get_connection
        with get_connection() as conn:
            cur = conn.cursor()
            
            # الأرباح المعلقة
            cur.execute("""
                SELECT COUNT(*) as count, SUM(amount) as total 
                FROM referral_earnings 
                WHERE status = 'pending'
            """)
            pending = cur.fetchone()
            
            # الأرباح المتاحة للتوزيع (10+ يوم)
            import datetime
            cutoff_date = (datetime.datetime.now() - datetime.timedelta(days=10)).isoformat()
            cur.execute("""
                SELECT COUNT(*) as count, SUM(amount) as total 
                FROM referral_earnings 
                WHERE status = 'pending' AND created_at <= ?
            """, (cutoff_date,))
            ready = cur.fetchone()
            
            stats_text = f"""
📊 **إحصائيات أرباح الإحالة:**

⏳ **الأرباح المعلقة:**
   • العدد: {pending['count'] or 0}
   • المجموع: {pending['total'] or 0:.2f} ل.س

✅ **الأرباح جاهزة للتوزيع (10+ يوم):**
   • العدد: {ready['count'] or 0}
   • المجموع: {ready['total'] or 0:.2f} ل.س

📅 **آخر توزيع:** {get_last_referral_distribution() or 'لم يتم التوزيع بعد'}
            """
    except Exception as e:
        print(f"❌ خطأ في جلب الإحصائيات: {e}")
        stats_text = "⚠️ حدث خطأ في جلب الإحصائيات"
    
    keyboard = [
        [InlineKeyboardButton("💰 توزيع الأرباح جاهزة (10+ يوم)", callback_data="distribute_ready_earnings")],
        [InlineKeyboardButton("🎯 توزيع جميع الأرباح المعلقة", callback_data="distribute_all_earnings")],
        [InlineKeyboardButton("📊 عرض تفاصيل الأرباح", callback_data="show_earnings_details")],
        [InlineKeyboardButton("🔙 رجوع للوحة الأدمن", callback_data="admin_panel")]
    ]
    
    reply_markup = InlineKeyboardMarkup(keyboard)
    
    await query.edit_message_text(
        stats_text,
        reply_markup=reply_markup,
        parse_mode="Markdown"
    )
    
    
async def distribute_ready_earnings(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """توزيع الأرباح الجاهزة (10+ يوم)"""
    query = update.callback_query
    await query.answer()
    
    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return
    
    # عرض رسالة تأكيد
    keyboard = [
        [InlineKeyboardButton("✅ نعم، قم بالتوزيع", callback_data="confirm_distribute_ready")],
        [InlineKeyboardButton("❌ إلغاء", callback_data="manual_referral_distribution")]
    ]
    reply_markup = InlineKeyboardMarkup(keyboard)
    
    await query.edit_message_text(
        "⚠️ **تأكيد توزيع الأرباح**\n\n"
        "هل تريد توزيع الأرباح المعلقة التي مضى عليها 10+ يوم؟\n"
        "سيتم تحويل الأرباح إلى محافظ المستخدمين مباشرة.",
        reply_markup=reply_markup,
        parse_mode="Markdown"
    )

async def confirm_distribute_ready(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """تنفيذ توزيع الأرباح الجاهزة"""
    query = update.callback_query
    await query.answer()
    
    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return
    
    # إرسال رسالة "جاري المعالجة"
    processing_msg = await query.edit_message_text(
        "⏳ **جاري توزيع الأرباح...**\n\n"
        "يرجى الانتظار، هذه العملية قد تستغرق بضع ثوانٍ.",
        parse_mode="Markdown"
    )
    
    try:
        import datetime
        from database import process_and_distribute_referral_earnings, set_last_referral_distribution
        
        now_iso = datetime.datetime.now().isoformat()
        
        # تنفيذ التوزيع (10 أيام)
        updated_count = process_and_distribute_referral_earnings(now_iso, 10)
        
        if updated_count > 0:
            # تحديث تاريخ آخر توزيع
            set_last_referral_distribution(now_iso)
            
            result_text = f"""
✅ **تم توزيع الأرباح بنجاح!**

📊 **النتائج:**
   • عدد الأرباح الموزعة: {updated_count}
   • التاريخ: {datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}

💰 تم تحويل الأرباح إلى محافظ المستخدمين.
            """
        else:
            result_text = """
ℹ️ **لا توجد أرباح جاهزة للتوزيع**

لا توجد أرباح معلقة مضى عليها 10+ يوم.
            """
        
        keyboard = [
            [InlineKeyboardButton("🔄 تحديث الإحصائيات", callback_data="manual_referral_distribution")],
            [InlineKeyboardButton("🔙 رجوع للوحة الأدمن", callback_data="admin_panel")]
        ]
        reply_markup = InlineKeyboardMarkup(keyboard)
        
        await processing_msg.edit_text(
            result_text,
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
        
    except Exception as e:
        print(f"❌ خطأ في التوزيع: {e}")
        
        keyboard = [
            [InlineKeyboardButton("🔄 المحاولة مرة أخرى", callback_data="distribute_ready_earnings")],
            [InlineKeyboardButton("🔙 رجوع", callback_data="manual_referral_distribution")]
        ]
        reply_markup = InlineKeyboardMarkup(keyboard)
        
        await processing_msg.edit_text(
            f"❌ **حدث خطأ أثناء التوزيع**\n\n"
            f"الخطأ: {str(e)}\n\n"
            f"يرجى المحاولة مرة أخرى أو مراجعة السجلات.",
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
        


async def distribute_all_earnings(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """توزيع جميع الأرباح المعلقة (للاستخدام في حالات خاصة)"""
    query = update.callback_query
    await query.answer()
    
    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return
    
    # عرض رسالة تأكيد مع تحذير
    keyboard = [
        [InlineKeyboardButton("⚠️ نعم، توزيع جميع الأرباح", callback_data="confirm_distribute_all")],
        [InlineKeyboardButton("❌ إلغاء", callback_data="manual_referral_distribution")]
    ]
    reply_markup = InlineKeyboardMarkup(keyboard)
    
    await query.edit_message_text(
        "⚠️ **تحذير: توزيع جميع الأرباح**\n\n"
        "هذا الإجراء سيقوم بتوزيع **جميع** الأرباح المعلقة بغض النظر عن وقت إنشائها.\n\n"
        "❌ **هذا مخالف للسياسة العادية (10 أيام انتظار)**\n\n"
        "استخدم هذا الخيار فقط في الحالات الخاصة مثل:\n"
        "• إغلاق النظام\n• ترقية النظام\n• حالات طارئة\n\n"
        "هل أنت متأكد من المتابعة؟",
        reply_markup=reply_markup,
        parse_mode="Markdown"
    )



async def confirm_distribute_all(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """توزيع شامل وتغيير حالة السجلات لمنع عودة الأرقام المعلقة"""
    query = update.callback_query
    await query.answer()

    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return

    processing_msg = await query.edit_message_text("⏳ **جاري التوزيع النهائي وتطهير السجلات...**", parse_mode="Markdown")

    try:
        import datetime, time, sqlite3
        from database import get_connection, set_last_referral_distribution
        
        now_iso = datetime.datetime.now().isoformat()
        
        with get_connection() as conn:
            conn.row_factory = sqlite3.Row
            cur = conn.cursor()

            # 1. جلب قائمة المستخدمين الذين لديهم أرباح معلقة فعلاً
            cur.execute("SELECT DISTINCT referrer_id FROM referral_earnings WHERE status = 'pending'")
            affected_users = [row['referrer_id'] for row in cur.fetchall()]

            if not affected_users:
                await processing_msg.edit_text("ℹ️ لا توجد أرباح معلقة حالياً.")
                return

            # 2. تحديث الرصيد الأساسي لكل مستخدم (إضافة المجموع المعلق للرصيد الحالي)
            for r_id in affected_users:
                cur.execute("""
                    UPDATE user_accounts 
                    SET balance = balance + (
                        SELECT COALESCE(SUM(amount), 0) 
                        FROM referral_earnings 
                        WHERE referrer_id = ? AND status = 'pending'
                    ),
                    referral_total = referral_total + (
                        SELECT COALESCE(SUM(amount), 0) 
                        FROM referral_earnings 
                        WHERE referrer_id = ? AND status = 'pending'
                    )
                    WHERE user_id = ?
                """, (r_id, r_id, r_id))

            # 3. الخطوة الأهم: تحويل حالة جيع الأرباح المعلقة إلى 'distributed' 
            # هذا يمنع أي دالة أخرى من رؤيتها كأرباح "معلقة"
            cur.execute("""
                UPDATE referral_earnings 
                SET status = 'distributed', 
                    distributed_at = ? 
                WHERE status = 'pending'
            """, (now_iso,))

            # 4. التصفير النهائي للأعمدة في جدول الحسابات
            cur.execute("UPDATE user_accounts SET referral_pending = 0, referral_available = 0")

            conn.commit()
            set_last_referral_distribution(now_iso)

            result_text = f"✅ **تم التوزيع والتطهير بنجاح!**\n\n📊 تم معالجة `{len(affected_users)}` مستخدمين.\n💰 الأرصدة الآن في حسابات السحب، والمعلق أصبح 0 نهائياً."

        await processing_msg.edit_text(result_text, reply_markup=InlineKeyboardMarkup([[InlineKeyboardButton("🔙 رجوع", callback_data="admin_panel")]]), parse_mode="Markdown")

    except Exception as e:
        print(f"❌ خطأ كارثي في التوزيع: {e}")
        await processing_msg.edit_text(f"❌ حدث خطأ: {str(e)}")


async def show_earnings_details(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """عرض تفاصيل الأرباح المعلقة"""
    query = update.callback_query
    await query.answer()
    
    user_id = str(query.from_user.id)
    if user_id not in map(str, ADMIN_IDS):
        await query.edit_message_text("⛔ غير مصرح لك!")
        return
    
    try:
        from database import get_connection
        import datetime
        
        with get_connection() as conn:
            cur = conn.cursor()
            
            # جلب الأرباح المعلقة مع تفاصيل
            cur.execute("""
                SELECT re.id, re.referrer_id, re.invited_id, re.amount, re.created_at,
                       ua1.username as referrer_name,
                       ua2.username as invited_name
                FROM referral_earnings re
                LEFT JOIN user_accounts ua1 ON re.referrer_id = ua1.user_id
                LEFT JOIN user_accounts ua2 ON re.invited_id = ua2.user_id
                WHERE re.status = 'pending'
                ORDER BY re.created_at DESC
                LIMIT 20
            """)
            
            earnings = cur.fetchall()
            
            if not earnings:
                details_text = "📭 لا توجد أرباح معلقة حالياً."
            else:
                details_text = "📋 **تفاصيل الأرباح المعلقة:**\n\n"
                
                for i, earning in enumerate(earnings, 1):
                    try:
                        # تحويل التاريخ
                        created_at = datetime.datetime.fromisoformat(earning['created_at'])
                        days_ago = (datetime.datetime.now() - created_at).days
                        
                        details_text += f"{i}. **رقم: {earning['id']}**\n"
                        details_text += f"   👤 المحيل: {earning['referrer_name'] or earning['referrer_id']}\n"
                        details_text += f"   👥 المدعو: {earning['invited_name'] or earning['invited_id']}\n"
                        details_text += f"   💰 المبلغ: {earning['amount']:.2f} ل.س\n"
                        details_text += f"   📅 مضى: {days_ago} يوم\n"
                        details_text += f"   ⏰ التاريخ: {created_at.strftime('%Y-%m-%d %H:%M')}\n\n"
                    except Exception as e:
                        details_text += f"{i}. ⚠️ خطأ في عرض التفاصيل\n\n"
                
                # إضافة ملخص
                cur.execute("SELECT COUNT(*) as total FROM referral_earnings WHERE status = 'pending'")
                total = cur.fetchone()['total']
                details_text += f"\n📊 **إجمالي الأرباح المعلقة: {total}**"
        
        keyboard = [
            [InlineKeyboardButton("🔄 تحديث", callback_data="show_earnings_details")],
            [InlineKeyboardButton("💰 توزيع الأرباح", callback_data="manual_referral_distribution")],
            [InlineKeyboardButton("🔙 رجوع", callback_data="admin_panel")]
        ]
        reply_markup = InlineKeyboardMarkup(keyboard)
        
        await query.edit_message_text(
            details_text,
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
        
    except Exception as e:
        print(f"❌ خطأ في عرض التفاصيل: {e}")
        
        keyboard = [
            [InlineKeyboardButton("🔙 رجوع", callback_data="manual_referral_distribution")]
        ]
        reply_markup = InlineKeyboardMarkup(keyboard)
        
        await query.edit_message_text(
            f"❌ **حدث خطأ في عرض التفاصيل**\n\n"
            f"الخطأ: {str(e)}",
            reply_markup=reply_markup,
            parse_mode="Markdown"
        )
async def toggle_syriatel_number_visibility(update, context):
    
    query = update.callback_query
    await query.answer()

    # جلب أرقام سيرياتيل
    numbers = DEPOSIT_INFO['syriatel_cash']

    keyboard = []
    for idx, item in enumerate(numbers, start=1):
        status = "🟢 مرئي" if item.get("visible", True) else "🔴 مخفي"
        keyboard.append([
            InlineKeyboardButton(
                f"{idx}. {item['number']} ({status})",
                callback_data=f"toggle_syriatel:{idx-1}"  # نرسل رقم الفهرس
            )
        ])

    keyboard.append([InlineKeyboardButton("🔙 العودة", callback_data="back_to_admin_panel")])
    reply_markup = InlineKeyboardMarkup(keyboard)

    await query.edit_message_text(
        "💰 إدارة أرقام سيرياتيل كاش:\nاضغط على الرقم لتبديل الحالة بين مخفي ومرئي",
        reply_markup=reply_markup
    )
async def handle_toggle_syriatel(update, context):
    query = update.callback_query
    await query.answer()

    data = query.data  # مثال: "toggle_syriatel:1"
    idx = int(data.split(":")[1])

    # تبديل الحالة
    DEPOSIT_INFO['syriatel_cash'][idx]['visible'] = not DEPOSIT_INFO['syriatel_cash'][idx]['visible']

    # إعادة عرض القائمة بعد التبديل
    await toggle_syriatel_number_visibility(update, context)
