import uuid
import time
import os
import re
import subprocess
import aiohttp
import json
from appium import webdriver
from appium.options.android import UiAutomator2Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from telegram import Bot, InlineKeyboardButton, InlineKeyboardMarkup
from config import BOT_TOKEN, ADMIN_IDS
from handlers.wallet.transaction_history import send_transaction_to_channel,send_transaction_to_channel_async , send_transaction_to_channel_via_bot

bot = Bot(token=BOT_TOKEN)

from handlers.admin.manage_rates import load_config

# ثم داخل الدالة request_withdrawal (أو في الأعلى كـ دالة مساعدة)
def get_withdrawal_fee_percent():
    config = load_config()
    return config.get("WITHDRAWAL_FEE_PERCENT", 5)         # نسبة الخصم
WITHDRAWAL_AUTO_LIMIT = 500_000     # الحد الأعلى للسحب التلقائي


# ===== نسخ النص إلى الحافظة =====
def copy_to_clipboard(text: str):
    """نسخ النص إلى حافظة ويندوز باستخدام AutoHotkey"""
    script_path = "copy_to_clipboard.ahk"
    cmd = [
        "C:\\Program Files\\AutoHotkey\\AutoHotkey.exe",
        script_path,
        text
    ]
    try:
        subprocess.run(cmd, check=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        time.sleep(0.5)
    except Exception as e:
        print(f"❌ فشل نسخ النص إلى الحافظة: {e}")


# ===== تنفيذ عملية السحب من تطبيق شام كاش =====
def execute_chamcash_withdrawal(client_code: str, amount: float, currency="SYP", device_udid: str = "127.0.0.1:5615") -> bool:
    """
    تنفيذ سحب شام كاش عبر التطبيق.
    currency: "SYP" للسوري، "USD" للدولار
    """
    copy_to_clipboard(client_code)
    app_package = "com.shmacash.shamcash"
    app_activity = "com.example.sham_cash.MainActivity"

    os.system(f"adb -s {device_udid} shell am start -n {app_package}/{app_activity}")
    time.sleep(10)

    options = UiAutomator2Options()
    options.platformName = "Android"
    options.deviceName = device_udid
    options.automationName = "UiAutomator2"
    options.appPackage = app_package
    options.appActivity = app_activity
    options.udid = device_udid
    options.noReset = True

    driver = None
    try:
        driver = webdriver.Remote("http://127.0.0.1:4724", options=options)
        wait = WebDriverWait(driver, 15)

        # إدخال PIN
        pin_input = wait.until(EC.presence_of_element_located((By.CLASS_NAME, "android.widget.EditText")))
        pin_input.click()
        time.sleep(0.5)
        pin_input.clear()
        pin_input.send_keys("1234")
        time.sleep(1)

        # الضغط على زر الإرسال الرئيسي
        send_main_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.ImageView[@content-desc="Send"]')
        ))
        send_main_btn.click()
        time.sleep(2)

        # الضغط على زر لصق الكود
        paste_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.FrameLayout[@resource-id="android:id/content"]/android.widget.FrameLayout/android.widget.FrameLayout/android.view.View/android.view.View/android.view.View/android.view.View[2]/android.widget.ImageView[2]')
        ))
        paste_btn.click()
        time.sleep(2)

        

        # الضغط على زر Show Account
        show_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Show Account"]')
        ))
        show_btn.click()
        time.sleep(2)

        # الضغط على زر Send بعد Show Account
        send_after_show = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Send"]')
        ))
        send_after_show.click()
        time.sleep(2)

        # اختيار العملة إذا لم تكن SYP (افتراضي)
        if currency == "USD":
            try:
                usd_btn = wait.until(EC.element_to_be_clickable(
                    (By.XPATH, '//android.view.View[@content-desc="USD"]')
                ))
                usd_btn.click()
                time.sleep(1)
            except Exception as e:
                print(f"❌ فشل اختيار الدولار: {e}")
                return False
        else:
            # إذا كانت SYP نضغط على زر SP
            try:
                sp_btn = wait.until(EC.element_to_be_clickable(
                    (By.XPATH, '//android.view.View[@content-desc="S.P"]')
                ))
                sp_btn.click()
                time.sleep(1)
            except Exception as e:
                print(f"❌ فشل اختيار الليرة السورية: {e}")
                # قد يكون زر SYP بالفعل مفعل افتراضيًا، نتابع

        # إدخال المبلغ
        amount_field = wait.until(EC.presence_of_element_located(
            (By.XPATH, '//android.widget.ScrollView/android.widget.EditText[1]')
        ))
        amount_field.click()
        time.sleep(0.5)
        amount_field.clear()
        time.sleep(0.5)
        amount_field.send_keys(str(int(amount)))
        time.sleep(1)

        # الضغط على زر الإرسال النهائي
        final_send_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Send"]')
        ))
        final_send_btn.click()
        time.sleep(2)

        # التحقق من نجاح العملية (يمكن إضافة تحقق من رسالة النجاح)
        try:
            # البحث عن رسالة نجاح أو أي عنصر يؤكد إتمام العملية
            wait.until(EC.presence_of_element_located(
                (By.XPATH, '//*[contains(@content-desc, "success") or contains(@content-desc, "تم") or contains(@content-desc, "نجاح")]')
            ))
            print("✅ تم إتمام عملية السحب بنجاح")
        except:
            # إذا لم نجد رسالة نجاح، قد تكون العملية مكتملة بأي شكل آخر
            print("⚠️ تم الضغط على زر الإرسال النهائي، تأكد يدويًا من إتمام العملية")

        return True

    except Exception as e:
        print(f"❌ خطأ أثناء السحب: {e}")
        return False

    finally:
        if driver:
            try:
                driver.quit()
            except:
                pass
        os.system(f"adb -s {device_udid} shell am force-stop {app_package}")





async def show_chamcash_balance(update, context):
    query = update.callback_query
    await query.answer()
    
    SHAMCASH_API_KEY = "43789f5c3757b1c696eabed53aafea9a6299013f0638cc7c2685e1e9840e65dd"
    SHAMCASH_ACCOUNT_ADDRESS = "131713feb16b1f420a0cbe364898536c"
    SHAMCASH_API_URL = "https://www.apisyria.com/api/v1"

    try:
        # بناء URL لطلب API
        api_url = f"{SHAMCASH_API_URL}?resource=shamcash&action=balance&account_address={SHAMCASH_ACCOUNT_ADDRESS}&api_key={SHAMCASH_API_KEY}"
        
        # إرسال طلب GET غير متزامن
        async with aiohttp.ClientSession() as session:
            async with session.get(api_url) as response:
                if response.status != 200:
                    await query.edit_message_text(f"❌ خطأ في الاتصال بالخادم: {response.status}")
                    return
                
                data = await response.json()
                
                # التحقق من نجاح الاستجابة
                if not data.get("success"):
                    error_msg = data.get("error", "خطأ غير معروف")
                    await query.edit_message_text(f"❌ فشل جلب الرصيد: {error_msg}")
                    return
                
                # استخراج البيانات
                account_data = data.get("data", {})
                balances = account_data.get("balances", [])
                
                # البحث عن أرصدة العملات
                syr_balance = 0
                usd_balance = 0
                
                for balance_item in balances:
                    currency = balance_item.get("currency", "").upper()
                    balance = balance_item.get("balance", 0)
                    
                    if currency == "SYP":
                        syr_balance = balance
                    elif currency == "USD":
                        usd_balance = balance
                
                # عرض الرصيد للادمن
                await query.edit_message_text(
                    f"💰 رصيد شام كاش الحالي:\n"
                    f"• الليرة السورية: {syr_balance:,} SYP\n"
                    f"• الدولار: {usd_balance:,} USD"
                )

    except aiohttp.ClientError as e:
        await query.edit_message_text(f"❌ خطأ في الاتصال: {e}")
    except json.JSONDecodeError as e:
        await query.edit_message_text(f"❌ خطأ في تحليل الاستجابة: {e}")
    except Exception as e:
        await query.edit_message_text(f"❌ فشل قراءة الرصيد: {e}")