# handlers/admin/deposit_approval.py

import time
from telegram import Update, InlineKeyboardMarkup, InlineKeyboardButton
from telegram.ext import ContextTypes

from config import ADMIN_IDS, PAYMENT_METHODS
from config import get_config
from config import OPERATIONS_CHANNEL_ID

async def approve_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    await query.answer()

    try:
        request_id = query.data.split(":")[1]
    except IndexError:
        await query.edit_message_text("❌ خطأ في رقم العملية.")
        return

    pending = db.get('pending_deposits', {})
    user_id_str = None
    user_deposit = None

    for uid, data in pending.items():
        if data.get("request_id") == request_id:
            user_id_str = uid
            user_deposit = data
            break

    if not user_deposit:
        await query.edit_message_text("⚠️ لم يتم العثور على هذا الطلب (قد تمت معالجته مسبقًا).")
        return

    amount = float(user_deposit.get("amount", 0))
    method = user_deposit.get("method", "").upper()
    user_id = int(user_id_str)

    # ✅ تطبيق البونص فقط على سيريتيل
    cfg = get_config()
    bonus_percent = float(cfg.get("Bouns_Gift", {}).get("SYRIATEL", 0)) if method == "SYRIATEL_CASH" or method == "SYRIATEL" else 0
    bonus_amount = amount * bonus_percent / 100 if bonus_percent > 0 else 0

    # 🔹 تحديث بيانات المستخدم
    user_acc = db.setdefault('user_accounts', {}).setdefault(user_id_str, {
        "balance": 0,
        "bonus_balance": 0,
        "history": []
    })

    user_acc["balance"] += amount
    user_acc["bonus_balance"] += bonus_amount
    user_acc["history"].append({
        "type": "DEPOSIT",
        "method": method,
        "amount": amount,
        "bonus": bonus_amount,
        "timestamp": time.time(),
        "status": "APPROVED"
    })

    # إزالة من الطلبات المعلقة
    del db['pending_deposits'][user_id_str]
    save_all_changes()

    # ✅ إشعار المستخدم
    try:
        await context.bot.send_message(
            chat_id=user_id,
            text=(
                f"💰 <b>تمت الموافقة على إيداعك!</b>\n\n"
                f"💵 المبلغ: <code>{amount:,.0f} ل.س</code>\n"
                f"🏦 الطريقة: <code>{method}</code>\n"
                + (f"🎁 بونص إضافي: <code>{bonus_amount:,.0f} ل.س</code>\n" if bonus_amount > 0 else "")
                + "\n✅ تم إضافة الرصيد إلى حسابك بنجاح."
            ),
            parse_mode='HTML'
        )
    except Exception as e:
        print(f"⚠️ لم أستطع إرسال إشعار للمستخدم {user_id}: {e}")

    # ✅ تعديل رسالة الأدمن
    await query.edit_message_text(
        f"✅ تم قبول إيداع المستخدم <code>{user_id}</code>\n"
        f"💰 المبلغ: <b>{amount:,.0f} ل.س</b>\n"
        + (f"🎁 بونص: {bonus_amount:,.0f} ل.س\n" if bonus_amount > 0 else ""),
        parse_mode='HTML'
    )

async def reject_deposit(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    await query.answer()

    parts = query.data.split(':', 1)
    if len(parts) != 2 or not parts[1]:
        await query.edit_message_text("❌ خطأ في معالجة الطلب.")
        return

    request_id = parts[1]
    pending = None
    user_id_str = None

    # البحث عن الطلب
    for uid, dep in db.get('pending_deposits', {}).items():
        if dep.get('request_id') == request_id:
            pending = dep
            user_id_str = uid
            break

    if not pending:
        await query.edit_message_text("❌ لم يتم العثور على طلب بهذا المعرف.")
        return

    amount = pending['amount']
    method = pending['method']

    # إزالة الطلب من pending
    del db['pending_deposits'][user_id_str]
    save_all_changes()

    response_text = (
        f"❌ تم رفض الإيداع:\n"
        f"👤 المستخدم: <code>{user_id_str}</code>\n"
        f"💰 المبلغ: <code>{int(amount)}</code> ل.س\n"
        f"💳 الطريقة: {PAYMENT_METHODS.get(method, method)}"
    )

    if query.message.text:
        await query.edit_message_text(response_text, parse_mode='HTML')
    else:
        await query.edit_message_caption(caption=response_text, parse_mode='HTML')

    # إشعار المستخدم
    try:
        await context.bot.send_message(
            chat_id=int(user_id_str),
            text=f"❌ تم رفض إيداعك بمبلغ <code>{int(amount)}</code> ل.س. الرجاء التواصل مع الدعم إذا كان هناك خطأ.",
            parse_mode='HTML'
        )
    except Exception as e:
        print(f"فشل إرسال إشعار للمستخدم {user_id_str}: {e}")
