import pandas as pd
import os
from datetime import datetime

from telegram import Update
from telegram.ext import ContextTypes

async def export_transactions_excel(update: Update, context: ContextTypes.DEFAULT_TYPE):
   
    query = update.callback_query
    await query.answer()

    # جلب سجل العمليات الناجحة فقط
    transactions = [
        log for log in db.get('transaction_logs', [])
        if log.get('status', 'success') == 'success'
    ]

    if not transactions:
        await query.message.reply_text("❌ لا توجد عمليات ناجحة لتصديرها.")
        return

    # إضافة المبلغ النهائي لكل سجل إذا كان موجودًا
    for log in transactions:
        if 'amount' in log:
            log['final_amount'] = log['amount']
        elif 'sent_amount' in log:
            log['final_amount'] = log['sent_amount']
        else:
            log['final_amount'] = ''

    # تحويل إلى DataFrame
    df = pd.DataFrame(transactions)

    # تنسيق الطابع الزمني
    df['timestamp'] = pd.to_datetime(df['timestamp'], unit='s').dt.strftime('%Y-%m-%d %H:%M:%S')

    # ترتيب الأعمدة
    column_order = [
        'timestamp', 'user_id', 'type', 'method', 'amount', 'requested_amount',
        'sent_amount', 'final_amount', 'fee_percent', 'client_number', 'tx_id'
    ]
    df = df.reindex(columns=[col for col in column_order if col in df.columns], fill_value='')

    # حفظ كملف Excel مؤقت
    filename = f"transactions_{datetime.now().strftime('%Y%m%d_%H%M%S')}.xlsx"
    filepath = os.path.join("exports", filename)
    os.makedirs("exports", exist_ok=True)
    df.to_excel(filepath, index=False, sheet_name="السجل")

    # إرسال الملف
    try:
        with open(filepath, 'rb') as f:
            await context.bot.send_document(
                chat_id=query.message.chat_id,
                document=f,
                caption="📊 تم تصدير سجل العمليات الناجحة بنجاح."
            )
    except Exception as e:
        await query.message.reply_text(f"❌ فشل إرسال الملف: {e}")
    finally:
        if os.path.exists(filepath):
            os.remove(filepath)
