from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes, ConversationHandler
from database import set_config_value  # دالة تحفظ قيمة في SQLite
from constants import AWAITING_EXCHANGE_RATE
from handlers.admin.admin_menu import admin_panel_handler

async def start_set_rate(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    keyboard = [
        [InlineKeyboardButton("❌ إلغاء والعودة للوحة الأدمن", callback_data="cancel_and_back_admin")]
    ]
    await query.edit_message_text(
        "💱 الرجاء إدخال سعر الصرف الجديد (1 دولار = ? ل.س)",
        reply_markup=InlineKeyboardMarkup(keyboard)
    )
    return AWAITING_EXCHANGE_RATE

async def receive_new_rate(update: Update, context: ContextTypes.DEFAULT_TYPE):
    try:
        new_rate = float(update.message.text)
        # حفظ سعر الصرف في قاعدة البيانات
        set_config_value("exchange_rate", new_rate)
        await update.message.reply_text(f"✅ تم تحديث سعر الصرف: 1 دولار = {new_rate} ل.س")
    except ValueError:
        await update.message.reply_text("❌ الرجاء إدخال رقم صالح.")
        return AWAITING_EXCHANGE_RATE
    return ConversationHandler.END

async def cancel_and_back_admin(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    await admin_panel_handler(update, context)
    return ConversationHandler.END
