# handlers/admin/hawala_settings.py

import re
import os
from telegram import Update
from telegram.ext import ContextTypes, ConversationHandler
from config import DEPOSIT_INFO
from constants import AWAITING_HAWALA_FULL_NAME, AWAITING_HAWALA_PHONE

def update_config_hawala(new_hawala_text: str):
    config_path = "config.py"
    if not os.path.exists(config_path):
        raise FileNotFoundError("لم يتم العثور على ملف config.py")

    # ✅ تحويل \n إلى \\n لتجنب كسر السطر في الملف
    escaped_for_file = new_hawala_text.replace("\\", "\\\\").replace('"', '\\"').replace("\n", "\\n")
    new_line = f'    \'hawala\': "{escaped_for_file}", # معلومات الحوالة\n'

    with open(config_path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    in_deposit_info = False
    hawala_replaced = False
    output_lines = []

    for line in lines:
        stripped = line.strip()
        if stripped.startswith("DEPOSIT_INFO = {"):
            in_deposit_info = True
            output_lines.append(line)
            continue

        if in_deposit_info:
            if stripped == "}":
                in_deposit_info = False
                output_lines.append(line)
                continue
            if "'hawala'" in line or '"hawala"' in line:
                output_lines.append(new_line)
                hawala_replaced = True
                continue

        output_lines.append(line)

    if not hawala_replaced:
        for i in range(len(output_lines) - 1, -1, -1):
            if output_lines[i].strip() == "}":
                output_lines.insert(i, new_line)
                break

    with open(config_path, "w", encoding="utf-8") as f:
        f.writelines(output_lines)


async def edit_hawala_info_start(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    await query.edit_message_text("✏️ أدخل الاسم الثلاثي الجديد لحوالة الهرم/فؤاد:")
    return AWAITING_HAWALA_FULL_NAME


async def receive_hawala_full_name(update: Update, context: ContextTypes.DEFAULT_TYPE):
    full_name = update.message.text.strip()
    if not full_name or len(full_name) < 5:
        await update.message.reply_text("❌ الاسم غير صالح. يجب أن يكون 5 أحرف على الأقل.")
        return AWAITING_HAWALA_FULL_NAME

    context.user_data['hawala_full_name'] = full_name
    await update.message.reply_text("📞 أدخل رقم الموبايل الجديد (مثال: 0933123456):")
    return AWAITING_HAWALA_PHONE


async def receive_hawala_phone(update: Update, context: ContextTypes.DEFAULT_TYPE):
    phone = update.message.text.strip()
    if not re.match(r'^09\d{8}$', phone):
        await update.message.reply_text("❌ رقم الموبايل غير صالح. يجب أن يكون 10 أرقام ويبتدي بـ 09.")
        return AWAITING_HAWALA_PHONE

    full_name = context.user_data['hawala_full_name']
    new_hawala_text = f"الاسم الثلاثي: {full_name}\nرقم الموبايل: {phone}"

    try:
        # 1. تحديث القيمة في الذاكرة (للاستخدام الفوري)
        from config import DEPOSIT_INFO as current_config
        current_config['hawala'] = new_hawala_text

        # 2. حفظ التغيير في config.py
        update_config_hawala(new_hawala_text)

        await update.message.reply_text("✅ تم تحديث معلومات الحوالة بنجاح وحفظها بشكل دائم!")
    except Exception as e:
        await update.message.reply_text(f"❌ فشل حفظ التغيير بشكل دائم: {str(e)}")

    return ConversationHandler.END
