from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ConversationHandler, CallbackQueryHandler, MessageHandler, filters, ContextTypes

# ملفات الإعدادات
from config import get_config
from handlers.admin.manage_rates import save_config
from handlers.admin.admin_menu import admin_panel_handler

AWAITING_REFERRAL_PERCENTAGES = 1001

async def start_edit_referral_percentages(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    cfg = get_config()
    ref_cfg = cfg.get("REFERRAL_COMMISSION", {})  # ← تحقق من اسم المفتاح الصحيح في config.json

    # إذا كان config.json يستخدم مفاتيح مثل "1", "2", "3" بدل "LEVEL_1"...
    msg = (
        "👥 **تعديل نسب الإحالات**\n\n"
        f"المستوى 1️⃣: {ref_cfg.get('1', 5)}%\n"
        f"المستوى 2️⃣: {ref_cfg.get('2', 2)}%\n"
        f"المستوى 3️⃣: {ref_cfg.get('3', 1)}%\n\n"
        "📝 أرسل القيم الجديدة مفصولة بفواصل مثل:\n"
        "`5,2,1`"
    )
    keyboard = [
        [InlineKeyboardButton("❌ إلغاء العملية", callback_data="cancel_referral_edit")]
    ]
    markup = InlineKeyboardMarkup(keyboard)

    await query.edit_message_text(msg, parse_mode="Markdown", reply_markup=markup)
    return AWAITING_REFERRAL_PERCENTAGES


async def receive_new_referral_percentages(update: Update, context: ContextTypes.DEFAULT_TYPE):
    try:
        values = [float(x.strip()) for x in update.message.text.split(",")]
        if len(values) != 3:
            raise ValueError
    except ValueError:
        await update.message.reply_text("❌ الرجاء إدخال 3 أرقام صحيحة مفصولة بفواصل مثل: `5,2,1`", parse_mode="Markdown")
        return AWAITING_REFERRAL_PERCENTAGES

    cfg = get_config()
    # ⚠️ التأكد من اسم المفتاح: هل هو "REFERRAL_COMMISSION" أم "REFERRAL_PERCENTAGES"؟
    cfg["REFERRAL_COMMISSION"] = {
        "1": values[0],
        "2": values[1],
        "3": values[2]
    }
    save_config(cfg)
    await update.message.reply_text(
        f"✅ تم تحديث نسب الإحالات بنجاح:\n"
        f"1️⃣ {values[0]}%\n2️⃣ {values[1]}%\n3️⃣ {values[2]}%",
        parse_mode="Markdown"
    )
    return ConversationHandler.END


async def cancel_referral_edit(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    await query.edit_message_text("❌ تم إلغاء تعديل نسب الإحالات. إعادة توجيه للوحة الأدمن...")
    await admin_panel_handler(update, context)
    return ConversationHandler.END