import requests
from decimal import Decimal, getcontext

getcontext().prec = 60

API_KEY = "84WMEET4HKXFAUWZQ19YQK68U1U19AVRSM"
CHAIN_ID = 56  # BSC Mainnet
ETHERSCAN_BASE = "https://api.etherscan.io/v2/api"
TRONSCAN_BASE = "https://apilist.tronscan.org/api/transaction-info"


def call_etherscan(txhash):
    params = {
        "chainid": CHAIN_ID,
        "module": "proxy",
        "action": "eth_getTransactionReceipt",
        "txhash": txhash,
        "apikey": API_KEY
    }
    r = requests.get(ETHERSCAN_BASE, params=params, timeout=20)
    r.raise_for_status()
    return r.json().get("result")


def call_tronscan(txhash):
    url = f"{TRONSCAN_BASE}?hash={txhash}"
    r = requests.get(url, timeout=20)
    r.raise_for_status()
    return r.json()


def hex_to_int(h):
    return int(h, 16) if h else 0


def normalize_addr(topic_hex):
    if not topic_hex:
        return None
    h = topic_hex[2:] if topic_hex.startswith("0x") else topic_hex
    return ("0x" + h[-40:]).lower()


def human_amount_from_raw(raw_int):
    return Decimal(raw_int) / (10**18)


def verify_tx(txhash, expected_amount, wallets):
    expected_amount = Decimal(expected_amount)
    for w in wallets:
        if isinstance(w, dict):
            addr = w.get("address", "").lower()
            w_type = w.get("type", "TRC20").upper()
        else:
            addr = str(w).lower()
            w_type = "TRC20"  # افتراضي

        if w_type == "BEP20":
            receipt = call_etherscan(txhash)
            if not receipt:
                continue

            logs = receipt.get("logs", [])
            print(f"📄 عدد الـ logs في المعاملة: {len(logs)}")
            for lg in logs:
                topics = lg.get("topics", [])
                to_addr = normalize_addr(topics[2]) if len(topics) > 2 else None
                value_raw = hex_to_int(lg.get("data", "0x0"))
                amount = human_amount_from_raw(value_raw)
                print(f"[BEP20] to={to_addr}, value_raw={value_raw}, amount={amount}, wallet={addr}")

                if to_addr == addr and round(amount, 6) == round(expected_amount, 6):
                    db.setdefault("transaction_logs", []).append({
                        "user_id": user_id,
                        "txhash": txhash,
                        "amount": float(amount),
                        "type": "BEP20",
                        "timestamp": str(Decimal.now())
                    })

                    # 💸 إضافة ربح الإحالة
                    if user_id:
                        add_referral_earning(invited_id=str(user_id), deposit_amount=float(amount))
                        print(f"🎁 تمت إضافة ربح إحالة للمستخدم {user_id}")

                    save_all_changes()
                    return {
                        "ok": True,
                        "amount": expected_amount,
                        "wallet": {"address": addr, "type": w_type}
                    }

        elif w_type == "TRC20":
            url = f"https://apilist.tronscan.org/api/transaction-info?hash={txhash}"
            res = requests.get(url, timeout=20).json()
            transfers = res.get("trc20TransferInfo", [])
            for t in transfers:
                to_addr = t.get("to_address", "").lower()
                amount = Decimal(t.get("amount_str", "0")) / Decimal(1_000_000)
                if to_addr == addr and round(amount, 6) == round(expected_amount, 6):
                    db.setdefault("transaction_logs", []).append({
                        "user_id": user_id,
                        "txhash": txhash,
                        "amount": float(amount),
                        "type": "TRC20",
                        "timestamp": str(Decimal.now())
                    })

                    # 💸 إضافة ربح الإحالة
                    if user_id:
                        add_referral_earning(invited_id=str(user_id), deposit_amount=float(amount))
                        print(f"🎁 تمت إضافة ربح إحالة للمستخدم {user_id}")

                    save_all_changes()
                    return {
                        "ok": True,
                        "amount": expected_amount,
                        "wallet": {"address": addr, "type": w_type}
                    }

    return {"ok": False, "amount": 0, "wallet": None}

