# handlers/game/game_handler.py

from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes, ConversationHandler
import random
import datetime
from constants import AWAITING_START_GAME, AWAITING_BOX_CHOICE
# 🟢 استيراد دوال SQLite الجديدة
from database import (
    get_user_data, 
    add_transaction,  # تستخدم لإضافة الجائزة وتحديث الرصيد
    add_user_history, # تستخدم لتسجيل العملية في تاريخ المستخدم
    _get_setting,     # لاسترجاع الإعدادات العامة (إذا لزم الأمر)
    # ❌ تم حذف load_db و save_all_changes
)


# ===== قاعدة بيانات مؤقتة لتتبع اللعب والجوائز (لا يزال هذا مطلوبًا لتتبع الحالة اليومية) =====
user_game_data = {}
# ⚠️ ملاحظة: يجب نقل هذا القاموس إلى مكان يتم حفظه فيه بشكل مستمر (مثل SQLite) للحفاظ على حالة اللعبة بين عمليات إعادة التشغيل،
# لكن سنبقيه هنا ليتوافق مع المنطق الأصلي للكود.


async def send_game_button(update: Update, context: ContextTypes.DEFAULT_TYPE):
    """يعرض زر البداية للعبة الصناديق."""
    reply_markup = InlineKeyboardMarkup([[InlineKeyboardButton("🎮 العب الآن", callback_data="start_game")]])

    chat_id = update.effective_chat.id if update.effective_chat else update.effective_user.id
    await context.bot.send_message(chat_id=chat_id, text="اضغط لتجربة حظك 🎲:", reply_markup=reply_markup)
    return AWAITING_START_GAME


async def start_game(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    await query.answer()
    user_id = query.from_user.id
    user_id_str = str(user_id)

    # 🟢 التعديل: استخدام get_user_data للتحقق من وجود الحساب
    account_data = get_user_data(user_id_str)
    if not account_data:
        await context.bot.send_message(
            chat_id=user_id,
            text="❌ يجب أن يكون لديك حساب لإمكانية لعب اللعبة. اضغط على 'حسابي' لإنشاء واحد."
        )
        return ConversationHandler.END

    today = datetime.date.today()
    user_data = user_game_data.get(user_id, {"last_play": None, "won_count": 0})

    if user_data["last_play"] == today:
        await context.bot.send_message(chat_id=user_id, text="⚠️ لقد لعبت اليوم، جرّب غدًا!")
        return ConversationHandler.END

    user_data["last_play"] = today
    user_game_data[user_id] = user_data

    keyboard = [
        [InlineKeyboardButton("📦 صندوق 1", callback_data="choose_box:1"),
         InlineKeyboardButton("📦 صندوق 2", callback_data="choose_box:2"),
         InlineKeyboardButton("📦 صندوق 3", callback_data="choose_box:3")]
    ]

    await context.bot.send_message(chat_id=user_id, text="اختر صندوقًا واحدًا 🎁:", reply_markup=InlineKeyboardMarkup(keyboard))
    return AWAITING_BOX_CHOICE


async def choose_box(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    query = update.callback_query
    await query.answer()
    user_id = query.from_user.id
    user_id_str = str(user_id)

    # 🟢 التعديل: استخدام get_user_data لجلب بيانات المستخدم
    account = get_user_data(user_id_str)
    if not account:
        await context.bot.send_message(chat_id=user_id, text="❌ ليس لديك حساب لتشغيل اللعبة.")
        return ConversationHandler.END

    # ⚠️ ملاحظة: يجب جلب إعداد الحد الأدنى من جدول app_settings بدلاً من القيمة الثابتة
    # بما أن القيمة الثابتة كانت 100,000، سنستخدمها مؤقتاً هنا.
    MIN_BALANCE_PER_CHANCE = 100000 
    
    user_balance = account.get('balance', 0.0)
    # فرصة فوز واحدة لكل 100,000 ل.س (كما في الكود الأصلي)
    win_chance_count = int(user_balance) // MIN_BALANCE_PER_CHANCE 

    user_data = user_game_data.get(user_id, {"won_count": 0})
    can_win = user_data["won_count"] < win_chance_count

    prizes = [0, 0, 0]
    if can_win and win_chance_count > 0:
        prizes[random.randint(0, 2)] = random.randint(1000, 3000)

    chosen_box = int(query.data.split(":")[1])
    prize = prizes[chosen_box - 1]

    if prize > 0:
        user_data["won_count"] += 1
        user_game_data[user_id] = user_data

        # 🟢 التعديل: استخدام add_transaction لتحديث الرصيد والسجلات في SQLite
        add_transaction(
            user_id=user_id_str, 
            tx_type="wheel_win", # استخدام نوع 'wheel_win' كما كان في نظامك القديم
            amount=prize, 
            method="box_game", 
            status="success"
        )
        # 🟢 التعديل: استخدام add_user_history (موجودة في database.py لديك)
        add_user_history(user_id_str, "box_win", prize, "game")
        
        # ❌ تم حذف: from database import save_all_changes و save_all_changes()
        # لأن add_transaction تقوم بالـ commit تلقائياً

        text = f"🎉 مبروك! ربحت {prize:,} ل.س وتم إضافتها إلى رصيدك!"
    else:
        text = "💨 الصندوق فارغ، حظًا أوفر في المرة القادمة!"

    await context.bot.send_message(chat_id=user_id, text=text)
    return ConversationHandler.END