# handlers/ishansy/ishansy_menu.py

from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes
from database import (
    get_user_data, # 🟢 لجلب بيانات المستخدم
    delete_user    # 🟢 لحذف بيانات المستخدم
    # ❌ تم حذف db, save_all_changes, load_db
) 
# ⚠️ تم افتراض أن هذا الثابت تم تعريفه، سيتم استخدامه في زر "الذهاب للموقع"
WEBSITE_URL = "https://ichancy.com" # ⬅️ استبدلها برابط موقعك الفعلي


# -------------------------------------------------------------------
# 1. الدالة الرئيسية: عرض القائمة وتفاصيل الحساب أو بدء الإنشاء
# -------------------------------------------------------------------

async def ishansy_menu_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    user_id_str = str(query.from_user.id)

    # 🟢 التعديل: استخدام get_user_data لجلب بيانات الحساب
    account = get_user_data(user_id_str)
    
    keyboard = []

    if not account:
        # 🟢 المستخدم جديد - طلب إنشاء حساب
        welcome_text = (
            "🖐️ أهلاً بك في البوت!\n\n"
            "📌 يمكنك إنشاء حساب **Luffy** لتتمكن من استخدام جميع خدمات البوت.\n"
            "📖 تفضل بقراءة دليل المستخدم وشروط البوت قبل البدء."
        )
        keyboard.append([InlineKeyboardButton("➕ إنشاء حساب Ichancy", callback_data="my_account")])
        keyboard.append([InlineKeyboardButton("📖 دليل المستخدم وشروط البوت", callback_data="user_guide")])
    else:
        # 🟡 المستخدم لديه حساب - عرض التفاصيل والعمليات
        username = account.get("username", "غير معروف")
        balance = account.get("balance", 0.0)
        bonus_balance = account.get("bonus_balance", 0.0)
        
        # ⚠️ (تم افتراض أنك تريد استخدام اسم المنصة "C" في الرسالة)
        welcome_text = (
            f"👤 **حساب {username} على Luffy Bot:**\n\n"
            f"💰 **رصيدك:** {int(balance):,} ل.س\n"
            f"🎁 **هدايا:** {int(bonus_balance):,} ل.س\n\n"
            "💠 اختر العملية المطلوبة:"
        )
        
        # 📝 أزرار العمليات المتاحة
        keyboard.append([InlineKeyboardButton("🌐 الذهاب إلى موقع Ichancy", url=WEBSITE_URL)])
        keyboard.append([InlineKeyboardButton("💳 تحويل رصيد إلى حساب Ichancy", callback_data="deposit_on_website")])
        keyboard.append([InlineKeyboardButton("💸 سحب رصيد Ichancy", callback_data="withdraw_from_website")])
        keyboard.append([InlineKeyboardButton("🗑️ حذف حسابي", callback_data="delete_my_account_warning")])

        

        
        # 🎁 زر رصيد الهدايا (مشروط)
        if bonus_balance > 0:
            keyboard.append([InlineKeyboardButton("🎁 شحن رصيد الهدايا إلى Ichancy", callback_data="transfer_bonus_to_ishansi")])
            
        # 🗑️ زر حذف الحساب
        

    # 🔙 زر العودة دائمًا
    keyboard.append([InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")])
    reply_markup = InlineKeyboardMarkup(keyboard)

    await query.edit_message_text(
        text=welcome_text,
        reply_markup=reply_markup,
        parse_mode="Markdown"
    )


# -------------------------------------------------------------------
# 2. وظائف حذف الحساب (الجديدة)
# -------------------------------------------------------------------

# 🔸 عرض التحذير قبل الحذف
async def delete_my_account_warning(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    warning_text = (
        "⚠️ *تحذير قبل حذف الحساب:*\n\n"
        "❗ بحذف حسابك، سيتم **حذف جميع بياناتك نهائيًا** من النظام.\n"
        "🚫 لن تتمكن من استعادة الحساب أو الأرصدة أو الهدايا.\n"
        "💳 لن يمكنك الإيداع أو السحب إلا بعد إنشاء حساب جديد.\n\n"
        "هل ترغب حقًا في حذف حسابك؟"
    )

    keyboard = [
        [
            InlineKeyboardButton("✅ نعم، احذف حسابي", callback_data="confirm_delete_account"),
            InlineKeyboardButton("❌ لا، أريد الاحتفاظ به", callback_data="cancel_delete_account")
        ]
    ]

    await query.edit_message_text(
        text=warning_text,
        parse_mode="Markdown",
        reply_markup=InlineKeyboardMarkup(keyboard)
    )

# 🔹 تنفيذ الحذف
async def confirm_delete_account(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    user_id_str = str(query.from_user.id)

    # 🟢 التعديل: استخدام get_user_data للتحقق ثم delete_user للحذف
    if get_user_data(user_id_str):
        # 🟢 تنفيذ الحذف
        delete_user(user_id_str)

        keyboard = [[InlineKeyboardButton("➕ إنشاء حساب جديد", callback_data="my_account")]]
        await query.edit_message_text(
            text="🗑️ تم حذف حسابك نهائيًا.\nيمكنك إنشاء حساب جديد في أي وقت.",
            reply_markup=InlineKeyboardMarkup(keyboard)
        )
    else:
        await query.edit_message_text("⚠️ لا يوجد حساب لحذفه.")

# 🔹 إلغاء الحذف برسالة لطيفة
async def cancel_delete_account(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    message = (
        "😊 جميل أنك قررت الاحتفاظ بحسابك!\n"
        "🎯 تذكّر أن البوت يقدم لك خدمات مميزة وسهلة الاستخدام."
    )

    # ⚠️ العودة إلى القائمة الرئيسية للمنصة (ishansy_menu)
    keyboard = [[InlineKeyboardButton("🔙 العودة إلى حسابي", callback_data="ishansy_menu")]]
    await query.edit_message_text(
        text=message,
        reply_markup=InlineKeyboardMarkup(keyboard)
    )