import datetime
from datetime import datetime, timedelta
from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes
# 🟢 استيراد دوال SQLite
from database import (
    get_user_data,
    get_referral_relationships,
    get_all_referral_earnings_by_referrer,
    get_last_referral_distribution,
    set_last_referral_distribution,
    get_user_referral_earnings_summary, # يفترض أن هذه الدالة تحسب الأرباح الإجمالية والمعلقة والمتاحة
    get_active_referrals_count,
    get_first_layer_referrals_count
)
from config import get_config
from handlers.referral.referral_scheduler import DAYS_TO_UNLOCK # يبقى كما هو


async def show_referral_info(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()

    # ... (منطق استخراج رقم الصفحة يبقى كما هو) ...
    data = query.data
    page = 0
    if data.startswith("referrals_page_"):
        try:
            page = int(data.split("_")[-1])
        except (ValueError, IndexError):
            page = 0
    
    user_id_str = str(query.from_user.id)
    
    # 🟢 1. التحقق من الحساب
    if not get_user_data(user_id_str):
        keyboard = [[InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")]]
        await query.edit_message_text("🚫 يجب إنشاء حساب أولاً.", reply_markup=InlineKeyboardMarkup(keyboard))
        return

    # 🟢 2. جلب ملخص الأرباح
    summary = get_user_referral_earnings_summary(user_id_str)
    total_earnings = summary['total']
    pending_earnings = summary['pending']
    available_earnings = summary['available']

    bot_username = (await context.bot.get_me()).username
    referral_link = f"https://t.me/{bot_username}?start=ref_{user_id_str}"

    # 🟢 3. بناء قائمة الإحالات (باستخدام دوال SQLite)
    relationships_dict = get_referral_relationships()
    
    def get_referrals_of(uid):
        return [invited for invited, ref in relationships_dict.items() if str(ref) == str(uid)]
    
    all_referrals_with_layer = []
    
    # الطبقة 1، 2، 3 (يبقى هذا المنطق في البايثون لاستبدال الوصول المباشر لـ db)
    for uid in get_referrals_of(user_id_str):
        all_referrals_with_layer.append((uid, 1))
        for uid2 in get_referrals_of(uid):
            all_referrals_with_layer.append((uid2, 2))
            for uid3 in get_referrals_of(uid2):
                all_referrals_with_layer.append((uid3, 3))
    
    # 🟢 4. جلب جميع الأرباح لهذا المُحيل
    all_earnings = get_all_referral_earnings_by_referrer(user_id_str)
    
    # --- تقسيم إلى صفحات ---
    per_page = 5
    total_items = len(all_referrals_with_layer)
    total_pages = (total_items + per_page - 1) // per_page 

    # 🟢 5. حساب وقت التوزيع القادم
    now = datetime.now()
    last_dist_str = get_last_referral_distribution()
    if last_dist_str:
        last_dist = datetime.fromisoformat(last_dist_str)
    else:
        last_dist = now
        set_last_referral_distribution(last_dist.isoformat()) 

    next_distribution = last_dist + timedelta(days=DAYS_TO_UNLOCK)
    remaining_time = max(next_distribution - now, timedelta(seconds=0))
    days = remaining_time.days
    hours = remaining_time.seconds // 3600
    minutes = (remaining_time.seconds % 3600) // 60
    # بعد بناء all_referrals_with_layer
    total_referrals_count = get_first_layer_referrals_count(user_id_str)

    # عدد الإحالات النشطة (مباشرة فقط)
    active_referrals_count = get_active_referrals_count(user_id_str)

    # جزء الرسالة الثابت
    message = (
        f"👥 **نظام الإحالات**\n\n"
        f"🔗 **رابطك:** `{referral_link}`\n\n"
        f"📊 **الإجمالي:** {total_earnings:.2f} ل.س\n"
        f"▫️ المعلقة: {pending_earnings:.2f} ل.س\n"
        f"👤 **إجمالي الإحالات:** {total_referrals_count}\n"
        f"🔥 **الإحالات النشطة:** {active_referrals_count}\n\n"
        f"▫️ القابلة للسحب: {available_earnings:.2f} ل.س\n"
        f"⏰ التوزيع القادم بعد: {days} يوم، {hours} ساعة، {minutes} دقيقة\n\n"
    )

    # --- عرض الصفحة الحالية ---
    if total_items == 0:
        message += "📭 **لا توجد إحالات بعد.**"
    else:
        start = page * per_page
        end = start + per_page
        page_items = all_referrals_with_layer[start:end]

        message += f"📜 **الصفحة {page + 1}/{total_pages}**\n\n"
        
        for uid, layer in page_items:
            # 🟢 التعديل: حساب الأرباح من القائمة المجلوبة مرة واحدة
            earnings = sum(e['amount'] for e in all_earnings if e['invited_id'] == uid)
            message += f"`{uid}` → 💰 {earnings:.2f} ل.س (طبقة {layer})\n"

    # ... أزرار التنقل والرد تبقى كما هي ...
    navigation_buttons = []
    if total_pages > 1:
        if page > 0:
            navigation_buttons.append(InlineKeyboardButton("⬅️ السابق", callback_data=f"referrals_page_{page - 1}"))
        if page < total_pages - 1:
            navigation_buttons.append(InlineKeyboardButton("التالي ➡️", callback_data=f"referrals_page_{page + 1}"))

    main_button = [InlineKeyboardButton("🔙 العودة للقائمة", callback_data="back_to_main")]
    keyboard = [navigation_buttons, main_button] if navigation_buttons else [main_button]

    await query.edit_message_text(
        text=message,
        reply_markup=InlineKeyboardMarkup(keyboard),
        parse_mode="Markdown"
    )
    
