# handlers/support/support_handler.py

from telegram import Update, InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import ContextTypes
from database import get_support_username 


async def support_handler(update: Update, context: ContextTypes.DEFAULT_TYPE):
    
    """
    يعالج الضغط على زر "مراسلة الدعم".
    """
    query = update.callback_query
    await query.answer()

    # جلب اسم مستخدم الدعم من قاعدة البيانات
    support_username = get_support_username()
    support_link = f"https://t.me/{support_username}"  # ✅ رابط صحيح بدون مسافات

    keyboard = [
        [InlineKeyboardButton("📩 اضغط هنا لمراسلة الدعم", url=support_link)],
        [InlineKeyboardButton("🔙 العودة للقائمة الرئيسية", callback_data="back_to_main")]
    ]
    reply_markup = InlineKeyboardMarkup(keyboard)
    
    await query.edit_message_text(
        "لأي سؤال أو مشكلة، الرجاء التواصل مع فريق الدعم عبر الضغط على الزر أدناه.",
        reply_markup=reply_markup
    )
