import os
import time
import re
from threading import Thread, Lock
from queue import Queue
from appium import webdriver
from appium.options.android import UiAutomator2Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from handlers.wallet.transaction_history import send_transaction_to_channel_via_bot
from handlers.notif.noti import send_real_withdrawal_to_channel
from database import (
    add_admin_history, 
    add_user_history, 
    get_transaction_by_details,  # جديد
    update_transaction_status,   # جديد
    refund_user_balance,         # جديد
    get_referrer_id,
    get_correct_refund_amount                       # جديد
    # ❌ حذف: db, save_data
)
from database import deduct_referral_on_loss , get_user_balance
from config import OPERATIONS_CHANNEL_ID , get_config
# ============================
# طابور الطلبات والقفل
# ============================

def get_syriatel_fee_percent():
    config = get_config()
    return float(config.get("WITHDRAWAL_FEE_PERCENT", {}).get("SYRIATEL", 0))

# في ملف cash_syriatel.py

withdraw_queue = Queue()
withdraw_lock = Lock()
global_bot = None  # ← سنضبطه لاحقًا
# في cash_syriatel.py
global_bot = None
global_job_queue = None  # ← جديد

def set_bot_and_job_queue(bot_instance, job_queue):
    global global_bot, global_job_queue
    global_bot = bot_instance
    global_job_queue = job_queue
def set_bot(bot_instance):
    global global_bot
    global_bot = bot_instance
# ============================
# وظيفة مساعدة لاستخراج الرصيد العددي من النص
# ============================
def extract_balance(text):
    """استخراج الرقم من نص مثل 'الرصيد: 125,000 ل.س'"""
    match = re.search(r'[\d,]+', text)
    if match:
        return int(match.group().replace(',', ''))
    return 0

# ============================
# الوظيفة الأساسية للسحب مع التحقق من الرصيد
# ============================

def cash_syriatel_cash_withdraw(client_code, amount, device_udid, pin="3611"):
    app_package = "sy.syriatel.selfservice"
    app_activity = "sy.syriatel.selfservice.ui.activities.MainActivity"

    print("⏳ تشغيل التطبيق على الجهاز...")
    os.system(f'adb -s {device_udid} shell am start -n {app_package}/{app_activity}')
    time.sleep(5)

    options = UiAutomator2Options()
    options.platformName = "Android"
    options.deviceName = device_udid
    options.automationName = "UiAutomator2"
    options.appPackage = app_package
    options.appActivity = app_activity
    options.udid = device_udid
    options.noReset = True

    driver = None
    for i in range(3):
        try:
            driver = webdriver.Remote("http://127.0.0.1:4727", options=options)
            break
        except Exception as e:
            print(f"❌ فشل الاتصال بـ Appium ({i+1}/3): {e}")
            time.sleep(3)
    if driver is None:
        print("❌ لم يتم إنشاء اتصال Appium.")
        return False

    wait = WebDriverWait(driver, 15)
    stop_flag = {"stop": False}

    # --- أدوات مساعدة ---
    def safe_click(xpath, timeout=15):
        el = WebDriverWait(driver, timeout).until(EC.element_to_be_clickable((By.XPATH, xpath)))
        el.click()
        return el

    def send_keys(xpath, text, timeout=15):
        el = WebDriverWait(driver, timeout).until(EC.presence_of_element_located((By.XPATH, xpath)))
        el.click()
        el.clear()
        el.send_keys(text)
        try:
            driver.hide_keyboard()
        except:
            pass
        return el

    def click_if_visible(xpath, timeout=2):
        try:
            el = WebDriverWait(driver, timeout).until(EC.presence_of_element_located((By.XPATH, xpath)))
            if el.is_displayed():
                el.click()
                return True
        except:
            pass
        return False

    def get_balance():
        """الحصول على رصيد المحفظة الحالي"""
        try:
            balance_el = wait.until(EC.presence_of_element_located(
                (By.XPATH, '//android.widget.TextView[@resource-id="sy.syriatel.selfservice:id/text_view_wallet_customer"]')
            ))
            balance_text = balance_el.text
            return extract_balance(balance_text)
        except Exception as e:
            print(f"⚠️ فشل قراءة الرصيد: {e}")
            return 0

    def get_current_account():
        """قراءة رقم الحساب الحالي"""
        try:
            el = wait.until(EC.presence_of_element_located(
                (By.XPATH, '//android.widget.TextView[@resource-id="sy.syriatel.selfservice:id/tv_gsm"]')
            ))
            return el.text.strip()
        except:
            return None

    def switch_account(account_number):
        """تبديل إلى حساب آخر وإرجاع رصيده"""
        safe_click('//android.widget.ImageButton[@resource-id="sy.syriatel.selfservice:id/iv_gsm_menu"]')
        time.sleep(1)
        safe_click(f'//android.widget.TextView[@resource-id="sy.syriatel.selfservice:id/tv_gsm" and @text="{account_number}"]')
        time.sleep(1.2)
        print(f"🔐 إعادة إدخال الـ PIN بعد التبديل إلى {account_number}...")
        safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/pin_insert"]')
        time.sleep(0.5)
        send_keys('//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/pin_code"]', pin)
        safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/confirm_btn"]')
        time.sleep(1)
        return get_balance()

    # --- خيط لمراقبة زر الخطأ ---
    def monitor_error_button():
        err_xpath = '//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/btn_error_action"]'
        while not stop_flag["stop"]:
            try:
                for btn in driver.find_elements(By.XPATH, err_xpath):
                    if btn.is_displayed():
                        print("❌ زر الخطأ ظهر، يتم الضغط عليه...")
                        btn.click()
                        time.sleep(0.5)
            except:
                pass
            time.sleep(0.4)

    Thread(target=monitor_error_button, daemon=True).start()

    try:
        # --- الدخول إلى المحفظة ---

        safe_click('(//android.widget.ImageView[@resource-id="sy.syriatel.selfservice:id/navigation_bar_item_icon_view"])[5]')
        time.sleep(0.7)
        safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/pin_insert"]')
        time.sleep(0.5)
        send_keys('//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/pin_code"]', pin)
        safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/confirm_btn"]')
        time.sleep(1)

        # --- التحقق من الحسابات بالترتيب ---
        accounts = ["0932121075", "0930699274","0995124755" ]
 # القائمة الكاملة
        current_account = get_current_account()
        print(f"📌 الحساب الحالي: {current_account}")

        current_balance = get_balance()
        

        if current_balance < amount:
            
            switched = False
            for acc in accounts:
                if acc != current_account:  # جرب فقط الحسابات الأخرى
                    new_balance = switch_account(acc)
                    
                    if new_balance >= amount:
                        
                        switched = True
                        break
            if not switched:
                
                return False
        else:
            pass

        # --- متابعة عملية التحويل ---
        # --- متابعة عملية التحويل ---
        safe_click('//androidx.recyclerview.widget.RecyclerView[@resource-id="sy.syriatel.selfservice:id/recycle_view_customer"]/android.widget.LinearLayout[4]/android.widget.LinearLayout')
        time.sleep(0.3)

        send_keys('//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/edit_text_code"]', client_code)
        send_keys('//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/edit_text_confirm_code"]', client_code)
        send_keys('//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/edit_text_amount"]', str(amount))

        # حقل تأكيد المبلغ
        amount2_candidates = [
            '//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/edit_text_confirm_amount"]',
            '(//android.widget.EditText[@resource-id="sy.syriatel.selfservice:id/edit_text_amount"])[2]',
        ]
        amount2_el = None
        for xp in amount2_candidates:
            try:
                amount2_el = wait.until(EC.presence_of_element_located((By.XPATH, xp)))
                if amount2_el:
                    amount2_el.click()
                    amount2_el.clear()
                    amount2_el.send_keys(str(amount))
                    try:
                        driver.hide_keyboard()
                    except:
                        pass
                    break
            except:
                continue
        if amount2_el is None:
            raise Exception("❌ لم يتم العثور على حقل تأكيد المبلغ.")

        time.sleep(0.3)
        safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/button_submit"]')
        time.sleep(0.3)

        # ===== حلقة التعامل مع أي أزرار وسيطة حتى يظهر زر التأكيد النهائي =====
        while True:
            # إذا ظهر زر android:id/button1 اضغط عليه
            clicked = click_if_visible('//android.widget.Button[@resource-id="android:id/button1"]', timeout=2)
            if clicked:
                print("⚠️ ظهر زر وسيط، تم الضغط عليه، إعادة الضغط على Submit")
                safe_click('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/button_submit"]')
                time.sleep(0.3)
                continue

            # إذا ظهر زر submit مرة أخرى (أحياناً يظهر بعد زر وسيط) اضغط عليه
            clicked_submit = click_if_visible('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/button_submit"]', timeout=2)
            if clicked_submit:
                print("⚠️ ظهر زر Submit مرة أخرى، تم الضغط عليه")
                time.sleep(0.3)
                continue

            # إذا ظهر زر التأكيد النهائي (button_continue) نضغطه ونخرج من الحلقة
            clicked_continue = click_if_visible('//android.widget.Button[@resource-id="sy.syriatel.selfservice:id/button_continue"]', timeout=2)
            if clicked_continue:
                
                break

            # إذا لم يظهر أي زر، انتظر قليلًا وأعد المحاولة
            time.sleep(0.5)

        
        return True


    except Exception as e:
        print(f"❌ خطأ أثناء السحب: {e}")
        return False

    finally:
        stop_flag["stop"] = True
        time.sleep(1)
        try:
            driver.quit()
        except:
            pass
        os.system(f'adb -s {device_udid} shell am force-stop {app_package}')

# ============================
# وظائف الطابور والإشعارات (بدون تغيير)
# ============================
def process_withdraw_request(client_code, amount, device_udid, pin, user_id_str):
    if global_job_queue is None:
        print("❌ Job queue غير مهيأ!")
        return

    chat_id = int(user_id_str)

    transaction_id = None
    updated_log = None

    # 🔥 جلب نسبة الخصم من config.json
    fee_percent = get_syriatel_fee_percent()

    async def notify_user(context, text: str, parse_mode="HTML"):
        try:
            await context.bot.send_message(chat_id=chat_id, text=text, parse_mode=parse_mode)
        except Exception as e:
            print(f"❌ فشل إرسال إشعار للمستخدم {chat_id}: {e}")

    # إشعار فوري
    global_job_queue.run_once(
        lambda ctx: notify_user(ctx, "⏳ **جارٍ تنفيذ عملية السحب...**\n\nسيتم إعلامك فور اكتمال العملية."),
        when=0
    )

    # 1️⃣ جلب المعاملة
    try:
        updated_log = get_transaction_by_details(client_code, float(amount))
        if updated_log:
            transaction_id = updated_log.get("transaction_id") or updated_log.get("id")

            if transaction_id:
                update_transaction_status(transaction_id, "processing")
                print(f"🔄 تم تحديث حالة المعاملة {transaction_id} إلى processing")
    except Exception as e:
        print(f"⚠️ خطأ في جلب المعاملة: {e}")

    # 🔐 حساب المبلغ الأصلي دائماً من amount + النسبة
    if fee_percent > 0:
        original_amount = round(amount / (1 - (fee_percent / 100)))
        fee_amount = original_amount - amount
    else:
        original_amount = amount
        fee_amount = 0

    display_original_amount = original_amount
    display_fee_amount = fee_amount

    # 2️⃣ تنفيذ السحب
    with withdraw_lock:
        try:
            success = cash_syriatel_cash_withdraw(client_code, amount, device_udid, pin)
        except Exception as e:
            print(f"❌ خطأ أثناء تنفيذ السحب: {e}")
            success = False

        new_status = "success" if success else "failed"

        if transaction_id:
            update_transaction_status(transaction_id, new_status)

        # ================= SUCCESS =================
        if success:
            global_job_queue.run_once(
                lambda ctx: notify_user(
                    ctx,
                    f"✅ **تم تنفيذ السحب بنجاح!**\n\n"
                    f"💰 **المبلغ المنقول:** {amount:,.0f} ل.س\n"
                    f"📞 **رقم العميل:** {client_code}\n"
                    f"⏰ **وقت التنفيذ:** {time.strftime('%H:%M:%S')}"
                ),
                when=0
            )

            

        # ================= FAILED =================
        else:
            # 🔥 الاسترداد الصحيح (المبلغ بعد الخصم)
            amount_to_refund = original_amount 

            refund_success = False
            try:
                refund_success = refund_user_balance(user_id_str, amount_to_refund)
            except Exception as e:
                print(f"❌ خطأ أثناء الاسترداد: {e}")

            if refund_success:
                global_job_queue.run_once(
                    lambda ctx: notify_user(
                        ctx,
                        f"❌ **فشل في تنفيذ السحب**\n\n"
                        f"📞 **رقم العميل:** {client_code}\n"
                        f"💰 **المبلغ المطلوب:** {display_original_amount:,.0f} ل.س\n"
                        f"📉 **رسوم السحب:** {display_fee_amount:,.0f} ل.س\n"
                        f"💸 **المبلغ المسترد:** {amount_to_refund:,.0f} ل.س\n\n"
                        f"✅ **تم استرداد المبلغ الصحيح إلى محفظتك.**\n"
                        f"🔄 **الرصيد الحالي:** {get_user_balance(user_id_str):,} ل.س"
                    ),
                    when=0
                )
            else:
                global_job_queue.run_once(
                    lambda ctx: notify_user(
                        ctx,
                        f"❌ **فشل في تنفيذ السحب**\n\n"
                        f"📞 **رقم العميل:** {client_code}\n"
                        f"💰 **المبلغ المطلوب:** {display_original_amount:,.0f} ل.س\n\n"
                        f"⚠️ **تعذر استرداد المبلغ، يرجى التواصل مع الدعم فوراً.**"
                    ),
                    when=0
                )

        # 5️⃣ التاريخ (بدون status لأن دالتك لا تقبله)
        try:
            history_amount = display_original_amount if not success else amount
            add_user_history(user_id_str, "withdraw", history_amount, "syriatel_cash")
            add_admin_history(user_id_str, "withdraw", history_amount, "syriatel_cash")
        except Exception as e:
            print(f"⚠️ خطأ في تسجيل التاريخ: {e}")

        # 6️⃣ قناة العمليات
        try:
            status_text = "✅ سحب ناجح" if success else "❌ سحب فاشل"
            channel_message = (
                f"💰 **عملية سحب سيرياتيل**\n\n"
                f"👤 **المستخدم:** {user_id_str}\n"
                f"📞 **رقم العميل:** {client_code}\n"
                f"💸 **المبلغ المطلوب:** {display_original_amount:,.0f} ل.س\n"
                f"📊 **الحالة:** {status_text}\n"
            )

            if not success:
                channel_message += (
                    f"📉 **رسوم السحب:** {display_fee_amount:,.0f} ل.س\n"
                    f"🔄 **المبلغ المسترد:** {amount_to_refund:,.0f} ل.س"
                )

            async def send_to_channel(context):
                await context.bot.send_message(
                    chat_id=OPERATIONS_CHANNEL_ID,
                    text=channel_message,
                    parse_mode="Markdown"
                )

            if OPERATIONS_CHANNEL_ID:
                global_job_queue.run_once(lambda ctx: send_to_channel(ctx), when=0)

        except Exception as e:
            print(f"⚠️ خطأ في إرسال القناة: {e}")

        time.sleep(0.5)


def withdraw_worker():
    while True:
        item = withdraw_queue.get()
        if item is None:
            break
        client_code, amount, device_udid, pin, user_id_str  = item
        process_withdraw_request(client_code, amount, device_udid, pin, user_id_str )
        withdraw_queue.task_done()

import threading
threading.Thread(target=withdraw_worker, daemon=True).start()

def enqueue_withdraw_request(client_code, amount, device_udid, pin, user_id_str ):
    if withdraw_lock.locked():
        # لا يمكن إرسال إشعار هنا لأننا في Thread، لذا نعتمد على الإشعار من syriatel_withdraw.py
        pass
    withdraw_queue.put((client_code, amount, device_udid, pin, user_id_str ))

# في نهاية دالة process_withdraw_request، بعد تنفيذ السحب:

# ============================
# وظائف الطابور والإشعارات
# ============================





