from telegram import InlineKeyboardButton, InlineKeyboardMarkup, Update
from telegram.ext import ContextTypes, ConversationHandler
from constants import AWAITING_SHAMCASH_CODE, AWAITING_SHAMCASH_AMOUNT
from handlers.menu.main_menu import start
from database import (
    get_user_data,
    update_user_field,
    deduct_user_balance,
    get_user_balance,
    create_pending_withdrawal,
    add_transaction,
    _get_setting as db_get_setting,
    refund_user_balance
)
import uuid
import time
from config import get_config, OPERATIONS_CHANNEL_ID

# --- زر الإلغاء ---
def get_cancel_button():
    return [InlineKeyboardButton("❌ إلغاء العملية", callback_data="cancel_withdraw_shamcash")]

CANCEL_NOTE = "\n\n⚠️ <b>ملاحظة:</b> يرجى إلغاء هذه العملية قبل الضغط على أي زر آخر من القائمة لتجنب تعارض الطلبات."

# --- دالة الإلغاء ---
async def cancel_withdraw_shamcash(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    await query.edit_message_text("❌ تم إلغاء عملية سحب شام كاش.", parse_mode='HTML')
    context.user_data.clear()
    return ConversationHandler.END

# --- نقطة الدخول بعد اختيار العملة ---
async def withdraw_shamcash_start(update: Update, context: ContextTypes.DEFAULT_TYPE):
    context.user_data.clear()
    context.user_data["is_withdrawing"] = True

    query = update.callback_query
    await query.answer()

    currency_type = "USD" if "usd" in query.data else "SYP"

    

    
    context.user_data['withdraw_currency'] = currency_type

    exchange_rate = db_get_setting("exchange_rate", 4500)
    config = get_config()
    syp_min_limit = config.get("MINIMUM_WITHDRAWAL", {}).get("SHAM", 500_000)
    syp_max_limit = config.get("MAX_DIRECT_WITHDRAW", {}).get("SHAM", 5_000_000)
    

    if currency_type == "USD":
        min_limit = max(round(syp_min_limit / exchange_rate), 10)
        max_limit = round(syp_max_limit / exchange_rate)
        currency_label = "دولار"
    else:
        min_limit = syp_min_limit
        max_limit = syp_max_limit
        currency_label = "ليرة سورية"

    context.user_data['min_withdraw'] = min_limit
    context.user_data['max_withdraw'] = max_limit

    cancel_button = get_cancel_button()
    await query.edit_message_text(
        f"🔢 أنت الآن تسحب شام كاش بـ **{currency_label}**.\n\n"
        f"الحد الأدنى للسحب: **{min_limit:,}** {currency_type}.\n"
        f"الحد الأقصى للسحب: **{max_limit:,}** {currency_type}.\n\n"
        f"الرجاء إدخال رمز العميل (Client Code):" + CANCEL_NOTE,
        reply_markup=InlineKeyboardMarkup([cancel_button]),
        parse_mode='HTML'
    )
    return AWAITING_SHAMCASH_CODE

# --- استلام رمز العميل ---
async def receive_shamcash_code(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from handlers.menu.main_menu import show_main_menu
    if update.message.text.startswith("/"):
        context.user_data.clear()
        await update.message.reply_text("❌ تم إلغاء عملية السحب.\n\n🔄 تمت إعادتك للصفحة الرئيسية.")
        await show_main_menu(update, context)
        return ConversationHandler.END


    code = update.message.text.strip()
    if not code:
        await update.message.reply_text("❌ الرجاء إدخال كود صالح.")
        return AWAITING_SHAMCASH_CODE

    context.user_data['shamcash_code'] = code
    cancel_button = get_cancel_button()
    await update.message.reply_text(
        "✅ تم استلام الرمز، الآن أدخل المبلغ المراد سحبه (بالأرقام فقط):" + CANCEL_NOTE,
        reply_markup=InlineKeyboardMarkup([cancel_button]),
        parse_mode='HTML'
    )
    return AWAITING_SHAMCASH_AMOUNT

# --- استلام المبلغ وتنفيذ السحب ---
# --- استلام المبلغ وتنفيذ السحب ---
async def receive_shamcash_amount(update: Update, context: ContextTypes.DEFAULT_TYPE):
    from handlers.menu.main_menu import show_main_menu
    if update.message.text.startswith("/"):
        context.user_data.clear()
        await update.message.reply_text("❌ تم إلغاء عملية السحب.\n\n🔄 تمت إعادتك للصفحة الرئيسية.")
        await show_main_menu(update, context)
        return ConversationHandler.END
    
    amount_text = update.message.text.strip()
    if not amount_text.isdigit():
        await update.message.reply_text("❌ الرجاء إرسال مبلغ صحيح (أرقام فقط).")
        return AWAITING_SHAMCASH_AMOUNT

    amount = int(amount_text)
    currency = context.user_data.get('withdraw_currency', 'SYP')
    MIN_WITHDRAW = context.user_data.get('min_withdraw', 500_000)
    MAX_WITHDRAW = context.user_data.get('max_withdraw', 5_000_000)
    client_code = context.user_data.get('shamcash_code')
    client_id = str(update.effective_user.id)

    # التحقق من الحدود
    if amount < MIN_WITHDRAW:
        await update.message.reply_text(
            f"❌ الحد الأدنى للسحب هو {MIN_WITHDRAW:,} {currency}.\n"
            f"الرجاء إدخال مبلغ أكبر أو يساوي {MIN_WITHDRAW:,} {currency}."
        )
        return AWAITING_SHAMCASH_AMOUNT
    
    if amount > MAX_WITHDRAW:
        await update.message.reply_text(
            f"❌ الحد الأقصى للسحب هو {MAX_WITHDRAW:,} {currency}.\n"
            f"الرجاء إدخال مبلغ أقل من أو يساوي {MAX_WITHDRAW:,} {currency}."
        )
        return AWAITING_SHAMCASH_AMOUNT

    # حساب المبلغ بالليرة السورية للخصم (فقط إذا كان المبلغ بالدولار)
    exchange_rate = db_get_setting("exchange_rate", 4500)
    
    if currency == "USD":
        amount_in_syp = amount * exchange_rate
        amount_to_store_in_db = amount_in_syp  # نختزن بالليرة في DB
        amount_to_show = amount  # نظهر بالدولار للمستخدم والأدمن
    else:
        amount_in_syp = amount  # المبلغ بالليرة هو نفسه
        amount_to_store_in_db = amount
        amount_to_show = amount

    config = get_config()
    fee_percent = config.get("WITHDRAWAL_FEE_PERCENT", {}).get("SHAM", 0)

    fee_amount_syp = int((amount_in_syp * fee_percent) / 100)
    amount_after_fee_syp = amount_in_syp - fee_amount_syp


    

    # التحقق من وجود المستخدم
    user_data = get_user_data(client_id)
    if not user_data:
        await update.message.reply_text("❌ حسابك غير موجود في النظام.")
        return ConversationHandler.END

    # التحقق من الرصيد
    current_balance = get_user_balance(client_id)
    if current_balance < amount_in_syp:
        await update.message.reply_text(f"❌ رصيدك غير كافي. رصيدك الحالي: {int(current_balance):,} ل.س")
        return AWAITING_SHAMCASH_AMOUNT

    

    # --- **الخطوة 2: إنشاء طلب سحب معلق** ---
    # هنا نحتاج لحفظ المبلغ الأصلي (بالدولار أو الليرة) في حقل amount_in_usdt
    amount_in_original_currency = amount  # المبلغ الأصلي بالدولار أو الليرة
    
    request_id = create_pending_withdrawal(
        user_id=client_id,
        client_code=client_code,
        amount=amount_to_store_in_db,  # المبلغ المخزن بالليرة
        method=f"chamcash_{currency.lower()}",
        network="",  # غير متوفر لشام كاش
        wallet_address="",  # غير متوفر لشام كاش
        amount_in_usdt=amount_in_original_currency if currency == "USD" else 0 , # نحفظ المبلغ الأصلي
        currency = currency
    )

    if not request_id:
        # في حالة فشل إنشاء الطلب، نعيد الرصيد
        refund_user_balance(client_id, amount_in_syp)
        await update.message.reply_text("❌ فشل في إنشاء طلب السحب. تم إعادة الرصيد.")
        return ConversationHandler.END

    # --- **الخطوة 3: إضافة سجل المعاملة** ---
    try:
        add_transaction(
            user_id=client_id,
            tx_type="withdraw",
            amount=amount_to_store_in_db,
            method=f"chamcash_{currency.lower()}_pending",
            status="pending",
            client_number=client_code
        )
    except Exception as e:
        print(f"⚠️ فشل إضافة سجل المعاملة: {e}")

    # --- **الخطوة 4: إشعار المستخدم** ---
    user_msg = (
        f"✅ تم تقديم طلب سحب شام كاش بنجاح!\n\n"
        f"📋 تفاصيل الطلب:\n"
        f"• المبلغ المطلوب: {amount_to_show:,} {currency}\n"
        f"• قيمة الخصم: {fee_amount_syp:,} ل.س\n"
        f"• المبلغ بعد الخصم: {amount_after_fee_syp:,} ل.س\n"
    )
    
    if currency == "USD":
        user_msg += f"• المبلغ المقابل: {amount_in_syp:,} ل.س\n"
    
    user_msg += (
        f"• رمز العميل: {client_code}\n"
        f"• حالة الطلب: ⏳ **قيد المراجعة من قبل الإدارة**\n\n"
        f"ℹ️ سيتم إخطارك فور الموافقة على الطلب من قبل الإدارة."
    )
    
    await update.message.reply_text(user_msg, parse_mode="HTML")

    # --- **الخطوة 5: إشعار القناة/الإدارة** ---
    if OPERATIONS_CHANNEL_ID:
        try:
            channel_text = (
                f"🆕 <b>طلب سحب شام كاش جديد:</b>\n"
                f"👤 المستخدم: <code>{client_id}</code>\n"
                f"💰 المبلغ المطلوب: {amount_to_show:,} {currency}\n"
                f"• قيمة الخصم: {fee_amount_syp:,} ل.س\n"
                f"• المبلغ بعد الخصم: {amount_after_fee_syp:,} ل.س\n"
            )
            
            if currency == "USD":
                channel_text += f"💵 المبلغ بالليرة: {amount_in_syp:,} ل.س\n"
                channel_text += f"📊 سعر الصرف: {exchange_rate:,} ل.س/دولار\n"
            
            channel_text += (
                f"💳 رمز العميل: <code>{client_code}</code>\n"
                f"🕒 الوقت: {time.strftime('%Y-%m-%d %H:%M:%S')}\n"
                f"📌 الحالة: ⏳ يحتاج مراجعة يدوية\n"
                f"🔗 معرّف الطلب: <code>{request_id}</code>"
            )
            
            # زر الموافقة السريعة
            keyboard = [
                [
                    InlineKeyboardButton("✅ الموافقة", callback_data=f"approve_withdraw:{request_id}"),
                    InlineKeyboardButton("❌ الرفض", callback_data=f"reject_withdraw:{request_id}")
                ]
            ]
            reply_markup = InlineKeyboardMarkup(keyboard)
            
            await context.bot.send_message(
                chat_id=OPERATIONS_CHANNEL_ID,
                text=channel_text,
                reply_markup=reply_markup,
                parse_mode="HTML"
            )
        except Exception as e:
            print(f"❌ فشل إرسال إشعار القناة: {e}")

    # --- **الخطوة 6: إنهاء المحادثة** ---
    context.user_data.clear()
    return ConversationHandler.END
# --- استرداد آخر طلب ---
async def refund_last_withdraw(update: Update, context: ContextTypes.DEFAULT_TYPE):
    query = update.callback_query
    await query.answer()
    user_id = str(update.effective_user.id)


    from database import DB_LOCK, get_connection
    import json

    pending_request = None
    with DB_LOCK:
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("""
                SELECT *
                FROM pending_withdrawals
                WHERE user_id = ?
                ORDER BY timestamp DESC
                LIMIT 1
            """, (user_id,))
            row = cur.fetchone()
            if row:
                pending_request = dict(row)

    if not pending_request:
        await query.edit_message_text("❌ لا يوجد طلب سحب قيد الانتظار للاسترداد.")
        return

    # استرداد الرصيد
    amount_to_refund = pending_request["requested_amount"]  # نفترض أن الحقل اسمه هكذا
    from database import refund_user_balance
    refund_user_balance(user_id, amount_to_refund)

    # حذف الطلب
    with DB_LOCK:
        with get_connection() as conn:
            cur = conn.cursor()
            cur.execute("DELETE FROM pending_withdrawals WHERE request_id = ?", (pending_request["request_id"],))

    # رسالة للمستخدم
    method = pending_request.get("method", "")
    if "usdt" in method.lower():
        usdt_amount = round(amount_to_refund / db_get_setting("exchange_rate", 4500))
        await query.edit_message_text(
            f"✅ تم استرداد طلب سحب USDT بقيمة {usdt_amount} USDT "
            f"({amount_to_refund:,} ل.س) إلى رصيدك."
        )
    else:
        await query.edit_message_text(
            f"✅ تم استرداد المبلغ {amount_to_refund:,} ليرة سورية إلى رصيدك."
        )