import uuid
import time
import os
import re
import subprocess
import math
import asyncio
from appium import webdriver
from appium.options.android import UiAutomator2Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from telegram import Bot, InlineKeyboardButton, InlineKeyboardMarkup
from config import BOT_TOKEN, ADMIN_IDS, get_config, OPERATIONS_CHANNEL_ID
from handlers.admin.manage_rates import load_config
from database import (
    get_user_data, deduct_user_balance, refund_user_balance, update_user_field,
    add_transaction, create_pending_withdrawal, log_transaction_and_get_id,
    get_referrer_id, deduct_referral_on_loss, _get_setting as db_get_setting,
    get_connection
)

# ===== دوال المساعدة =====
def get_withdrawal_fee_percent(method="SHAM"):
    """جلب نسبة الخصم لطريقة السحب المحددة من ملف الإعدادات."""
    config = load_config()
    return config.get("WITHDRAWAL_FEE_PERCENT", {}).get(method, 5)

def round_auto_withdrawal(amount: float) -> int:
    """تقريب المبلغ للآلاف حسب طلب المستخدم (آلي)."""
    remainder = amount % 1000
    if remainder <= 500:
        return int(math.floor(amount / 1000) * 1000)
    else:
        return int(math.ceil(amount / 1000) * 1000)

def copy_to_clipboard(text: str):
    """نسخ النص إلى حافظة ويندوز باستخدام AutoHotkey"""
    script_path = "copy_to_clipboard.ahk"
    cmd = [
        "C:\\Program Files\\AutoHotkey\\AutoHotkey.exe",
        script_path,
        text
    ]
    try:
        subprocess.run(cmd, check=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        time.sleep(0.5)
    except Exception as e:
        print(f"❌ فشل نسخ النص إلى الحافظة: {e}")

# ===== تنفيذ عملية السحب من تطبيق شام كاش =====
def execute_chamcash_withdrawal(client_code: str, amount: float, currency="SYP", device_udid: str = "127.0.0.1:5615") -> bool:
    """
    تنفيذ سحب شام كاش عبر التطبيق.
    currency: "SYP" للسوري، "USD" للدولار
    """
    rounded_amount = amount
    
    copy_to_clipboard(client_code)
    app_package = "com.shmacash.shamcash"
    app_activity = "com.example.sham_cash.MainActivity"

    os.system(f"adb -s {device_udid} shell am start -n {app_package}/{app_activity}")
    time.sleep(10)

    options = UiAutomator2Options()
    options.platformName = "Android"
    options.deviceName = device_udid
    options.automationName = "UiAutomator2"
    options.appPackage = app_package
    options.appActivity = app_activity
    options.udid = device_udid
    options.noReset = True

    driver = None
    try:
        driver = webdriver.Remote("http://127.0.0.1:4724", options=options)
        wait = WebDriverWait(driver, 15)

        # إدخال PIN
        pin_input = wait.until(EC.presence_of_element_located((By.CLASS_NAME, "android.widget.EditText")))
        pin_input.click()
        time.sleep(0.5)
        pin_input.clear()
        pin_input.send_keys("1234")
        time.sleep(1)

        # التحقق من الرصيد
        if currency == "USD":
            try:
                # العثور على عنصر رصيد الدولار مباشرة
                balance_el = wait.until(EC.presence_of_element_located(
                    (By.XPATH, '//android.view.View[contains(@content-desc, "USD")]')
                ))

                # قراءة النص الكامل
                full_usd_text = balance_el.get_attribute("content-desc")
                
                # استخراج الرقم باستخدام regex
                matches = re.findall(r'\d+', full_usd_text.replace(",", ""))
                usd_balance = int(matches[0]) if matches else 0

                if usd_balance < amount:
                    print(f"❌ رصيد الدولار غير كافٍ. الرصيد الحالي: {usd_balance}")
                    return False

            except Exception as e:
                print(f"❌ لم يتم العثور على رصيد الدولار: {e}")
                return False

        else:
            # رصيد الليرة السورية
            try:
                balance_el = wait.until(EC.presence_of_element_located(
                    (By.XPATH, '//android.view.View[contains(@content-desc, "Syrian pound")]')
                ))

                full_syr_text = balance_el.get_attribute("content-desc")

                # 1. تنظيف النص (إزالة الفواصل)
                cleaned_text = full_syr_text.replace(",", "")

                # 2. البحث عن أول تسلسل أرقام
                matches = re.findall(r'(\d+)', cleaned_text)
                
                # 3. الحصول على الرصيد بأمان
                current_balance = int(matches[0]) if matches else 0

                print(f"ℹ️ النص المقروء لليرة: {full_syr_text}")
                print(f"ℹ️ الرصيد المستخرج لليرة: {current_balance}")

                if current_balance < amount:
                    print(f"❌ رصيد الليرة السورية غير كافٍ. المطلوب: {amount:,}، الحالي: {current_balance:,}")
                    return False
            
            except Exception as e:
                print(f"❌ لم يتم العثور على رصيد الليرة السورية: {e}")
                return False

        # تنفيذ الخطوات في التطبيق
        services_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.view.View[contains(@content-desc, "Services")]/android.view.View[1]/android.widget.Button[2]')
        ))
        services_btn.click()
        time.sleep(2)

        paste_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Paste the Address"]')
        ))
        paste_btn.click()
        time.sleep(2)

        # تأكيد الكود
        try:
            wait.until(EC.presence_of_element_located(
                (By.XPATH, f'//android.view.View[@content-desc="{client_code}"]')
            ))
            
        except:
            print("❌ فشل لصق الكود")
            return False

        # Show Account
        show_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Show Account"]')
        ))
        show_btn.click()
        time.sleep(2)
        

        # Send
        send_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Send"]')
        ))
        send_btn.click()
        time.sleep(2)
        if currency == "USD":
            try:
                usd_btn = wait.until(EC.element_to_be_clickable(
                    (By.XPATH, '//android.view.View[@content-desc="USD"]')
                ))
                usd_btn.click()
                time.sleep(1)
                print("ℹ️ تم اختيار الدولار بعد Show Account")
            except Exception as e:
                print(f"❌ فشل اختيار الدولار بعد Show Account: {e}")
                return False

        # إدخال المبلغ
        amount_field = wait.until(EC.presence_of_element_located(
            (By.XPATH, '//android.widget.ScrollView/android.widget.EditText[1]')
        ))
        amount_field.click()
        amount_field.clear()
        amount_field.send_keys(str(int(rounded_amount)))
        time.sleep(1)

        # تأكيد الإرسال النهائي
        final_btn = wait.until(EC.element_to_be_clickable(
            (By.XPATH, '//android.widget.Button[@content-desc="Send" or @content-desc="Continue"]')
        ))
        final_btn.click()

        time.sleep(3)  # انتظار اكتمال العملية
        
        return True

    except Exception as e:
        print(f"❌ خطأ أثناء السحب: {e}")
        return False

    finally:
        if driver:
            try:
                driver.quit()
            except:
                pass
        os.system(f"adb -s {device_udid} shell am force-stop {app_package}")

def send_message_sync(bot, loop, chat_id, text, parse_mode="HTML", reply_markup=None):
    """
    دالة مساعدة لإرسال الرسائل من داخل Thread باستخدام الـ Loop الرئيسي.
    """
    if loop is None:
        print("❌ خطأ: لم يتم تمرير الـ Loop الرئيسي إلى send_message_sync.")
        return 
    
    try:
        # نرسل المهمة للـ Loop الرئيسي لتنفيذها بشكل آمن
        asyncio.run_coroutine_threadsafe(
            bot.send_message(chat_id=chat_id, text=text, parse_mode=parse_mode, reply_markup=reply_markup),
            loop
        )
    except Exception as e:
        print(f"❌ خطأ في إرسال رسالة غير متزامنة (Sync Message): {e}")
def request_withdrawal_sync(client_id: str, client_code: str, bot, amount: float, currency: str = "SYP", amount_in_syp: float = 0.0, main_loop=None):
    """
    معالجة طلب السحب وتنفيذه تلقائياً أو إرساله للموافقة.
    تم تحديث للعمل مع قاعدة بيانات SQLite.
    """
    print(f"🔄 بدء معالجة سحب شام كاش: {amount:,} {currency} لـ {client_id}")
    
    user = get_user_data(client_id)
    if not user:
        print(f"❌ المستخدم {client_id} غير موجود")
        return "❌ لا يمكن العثور على بيانات المستخدم."

    # جلب الرسوم والحدود
    fee_percent = get_withdrawal_fee_percent("SHAM")
    fee_amount = (amount * fee_percent) / 100
    net_amount = amount - fee_amount   # المبلغ الذي سيستلمه العميل بعد الخصم
    rounded_amount = round_auto_withdrawal(net_amount)

    # 1. جلب الحدود من الكونفيغ بالليرة السورية
    config = load_config()
    syp_max_limit = config.get("MAX_DIRECT_WITHDRAW", {}).get("SHAM", 5000000)
    
    # 2. تحديد الحد الأقصى للسحب التلقائي بناءً على العملة
    exchange_rate = db_get_setting("exchange_rate", 4500)
    if currency == "USD":
        WITHDRAWAL_AUTO_LIMIT = round(syp_max_limit / exchange_rate)
    else:  # SYP
        WITHDRAWAL_AUTO_LIMIT = syp_max_limit
    
    # 3. تحديد طريقة السحب
    is_auto_withdrawal = amount <= WITHDRAWAL_AUTO_LIMIT

    

    # ====================== السحب التلقائي ======================
    if is_auto_withdrawal:
        device_udid = "127.0.0.1:5615"
        app_package = "com.shmacash.shamcash"

        print(f"🔄 بدء السحب التلقائي...")
        success = execute_chamcash_withdrawal(client_code, rounded_amount, currency, device_udid)

        if success:
            print(f"✅ السحب التلقائي ناجح")
            
            # تسجيل السحب في قاعدة البيانات باستخدام add_transaction
            add_transaction(
                user_id=client_id,
                tx_type="withdraw",
                amount=amount_in_syp,
                method=f"chamcash_{currency.lower()}",
                status="success",
                client_number=client_code
            )
            
            # إذا أردت حفظ تفاصيل إضافية، يمكنك إنشاء دالة جديدة أو تعديل add_transaction
            # لحفظ البيانات الإضافية في حقل extra إذا كان موجوداً
            try:
                # محاولة إضافة البيانات الإضافية إلى حقل extra إذا كان الجدول يدعمه
                import json
                from database import get_connection, DB_LOCK
                extra_data = {
                    "requested_amount": amount,
                    "sent_amount": rounded_amount,
                    "fee_percent": fee_percent,
                    "currency": currency,
                    "original_currency": currency,
                    "client_code": client_code,
                    "withdrawal_type": "auto"
                }
                
                with DB_LOCK:
                    with get_connection() as conn:
                        cur = conn.cursor()
                        # تحديث آخر سجل لهذا المستخدم بإضافة البيانات الإضافية
                        cur.execute("""
                            UPDATE transaction_logs 
                            SET extra = ? 
                            WHERE id = (SELECT MAX(id) FROM transaction_logs WHERE user_id = ? AND type = 'withdraw')
                        """, (json.dumps(extra_data), client_id))
                        conn.commit()
                        
            except Exception as e:
                print(f"⚠️ لم يتم حفظ البيانات الإضافية: {e}")
            
            # تحديث حالة has_withdrawn للمستخدم
            update_user_field(client_id, "has_withdrawn", 1)
            
            # خصم أرباح الإحالة
            

            # إرسال العملية لقناة العمليات
            if OPERATIONS_CHANNEL_ID and main_loop:
                async def notify_channel():
                    try:
                        await bot.send_message(
                            chat_id=OPERATIONS_CHANNEL_ID,
                            text=(
                                f"💸 <b>سحب شام كاش تلقائي ناجح:</b>\n"
                                f"👤 المستخدم: <code>{client_id}</code>\n"
                                f"💰 المبلغ المطلوب: {amount:,} {currency}\n"
                                f"💵 المبلغ بعد الخصم ({fee_percent}%): {rounded_amount:,} {currency}\n"
                                f"💳 رمز العميل: <code>{client_code}</code>\n"
                                f"🕒 الوقت: {time.strftime('%Y-%m-%d %H:%M:%S')}\n"
                                f"📌 الحالة: ✅ تم التنفيذ آلياً"
                            ),
                            parse_mode="HTML"
                        )
                    except Exception as e:
                        print(f"⚠️ فشل إرسال إشعار للقناة: {e}")

                asyncio.run_coroutine_threadsafe(notify_channel(), main_loop)

            return {
                "success": True,
                "original_amount": amount,
                "rounded_amount": rounded_amount,
                "currency": currency,
                "fee_percent": fee_percent,
                "client_code": client_code
            }

        else:
            print(f"❌ فشل السحب التلقائي، التحويل للطلب اليدوي")
            is_auto_withdrawal = False  # الانتقال للطلب اليدوي إذا فشل

    # ====================== الطلب اليدوي ======================
    if not is_auto_withdrawal:
        print(f"🔄 إنشاء طلب سحب يدوي...")
        
        request_id = create_pending_withdrawal(
            user_id=client_id,
            client_code=client_code,
            amount=amount,
            method=f"chamcash_{currency.lower()}"
        )

        if not request_id:
            print(f"❌ فشل في إنشاء طلب السحب المعلق")
            return "❌ فشل في معالجة طلب السحب."

        keyboard = InlineKeyboardMarkup([
            [
                InlineKeyboardButton("✅ موافقة", callback_data=f"approve_withdraw:{request_id}"),
                InlineKeyboardButton("❌ رفض", callback_data=f"reject_withdraw:{request_id}")
            ]
        ])

        # إشعار الأدمن
        for admin_id in ADMIN_IDS:
            send_message_sync(
                bot,
                loop=main_loop,
                chat_id=admin_id,
                text=(
                    f"🚨 <b>طلب سحب شام كاش جديد (يدوي):</b>\n\n"
                    f"👤 المستخدم: <code>{client_id}</code>\n"
                    f"💰 المبلغ: <b>{amount:,} {currency}</b>\n"
                    f"💵 ما يعادلها بالليرة: <b>{amount_in_syp:,.0f} SYP</b>\n"
                    f"💵 بعد الخصم ({fee_percent}%): <b>{net_amount:,.2f} {currency}</b>\n"
                    f"💳 رمز العميل: <code>{client_code}</code>\n"
                    f"🕒 الوقت: {time.strftime('%Y-%m-%d %H:%M:%S')}\n"
                ),
                parse_mode="HTML",
                reply_markup=keyboard
            )

        # إرسال إشعار لقناة العمليات
        if OPERATIONS_CHANNEL_ID and main_loop:
            async def notify_operations_channel():
                try:
                    await bot.send_message(
                        chat_id=OPERATIONS_CHANNEL_ID,
                        text=(
                            f"📋 <b>طلب سحب شام كاش جديد:</b>\n"
                            f"👤 المستخدم: <code>{client_id}</code>\n"
                            f"💰 المبلغ: {amount:,} {currency}\n"
                            f"💵 ما يعادلها بالليرة: {amount_in_syp:,.0f} SYP\n"
                            f"💵 بعد الخصم ({fee_percent}%): {net_amount:,.2f} {currency}\n"
                            f"💳 رمز العميل: <code>{client_code}</code>\n"
                            f"🕒 الوقت: {time.strftime('%Y-%m-%d %H:%M:%S')}\n"
                            f"📌 الحالة: ⏳ بانتظار المراجعة"
                        ),
                        parse_mode="HTML"
                    )
                except Exception as e:
                    print(f"⚠️ فشل إرسال إشعار لقناة العمليات: {e}")

            asyncio.run_coroutine_threadsafe(notify_operations_channel(), main_loop)

        return f"✅ تم استلام طلب سحب **{amount:,} {currency}**.\nسيتم مراجعته من قبل الإدارة قريبًا."

    return "❌ حدث خطأ غير متوقع."
# دالة مساعدة لمعالجة نتائج السحب
async def process_withdrawal_result(client_id: str, result, bot, currency: str, amount: float, client_code: str, amount_in_syp: float):
    """معالجة نتائج السحب وإرسال الرسائل المناسبة."""
    if isinstance(result, dict) and result.get("success", False):
        success_msg = (
            f"✅ تم سحب **{amount:,} {currency}** بنجاح!\n\n"
            f"📋 تفاصيل العملية:\n"
            f"• المبلغ الأصلي: {amount:,} {currency}\n"
            f"• المبلغ المحوَّل بعد الخصم ({result.get('fee_percent', 5)}%): {result.get('rounded_amount', amount):,} {currency}\n"
            f"• رمز العميل: {client_code}\n"
            f"• وقت التنفيذ: {time.strftime('%H:%M:%S')}"
        )
        await bot.send_message(chat_id=int(client_id), text=success_msg, parse_mode="HTML")
        
    elif isinstance(result, dict) and not result.get("success", False):
        # فشل السحب التلقائي - استرداد الرصيد
        refund_user_balance(client_id, amount_in_syp)
        error_msg = (
            f"❌ فشل السحب التلقائي للمبلغ **{amount:,} {currency}**.\n\n"
            f"📋 التفاصيل:\n"
            f"• المبلغ المطلوب: {amount:,} {currency}\n"
            f"• رمز العميل: {client_code}\n"
            f"• السبب: {result.get('reason', 'غير معروف')}\n\n"
            f"✅ تم استرداد المبلغ ({amount_in_syp:,.0f} ل.س) إلى رصيدك."
        )
        await bot.send_message(chat_id=int(client_id), text=error_msg, parse_mode="HTML")
        
    elif isinstance(result, str):
        # رسالة نصية (عادة طلب يدوي)
        await bot.send_message(chat_id=int(client_id), text=result, parse_mode="HTML")