# requirements:
# pip install requests beautifulsoup4

import requests, re, json
from bs4 import BeautifulSoup

URL = "https://agents.ichancy.com/"
SITEKEY = "0x4AAAAAAADnPIDROrmt1Wwj"

headers = {"User-Agent": "Mozilla/5.0 (compatible; script/1.0)"}
resp = requests.get(URL, headers=headers, timeout=20)
resp.raise_for_status()
html = resp.text

soup = BeautifulSoup(html, "html.parser")

results = {
    "found_in_dom": [],
    "scripts_with_sitekey": [],
    "json_like_matches": []
}

# 1) تحقق من وجود sitekey في عناصر DOM (attributes / text)
for el in soup.find_all(True):
    for attr, val in el.attrs.items():
        if isinstance(val, list):
            val = " ".join(val)
        if SITEKEY in str(val):
            results["found_in_dom"].append({
                "tag": el.name,
                "attr": attr,
                "value": val[:400]
            })
    # نص العنصر
    if el.string and SITEKEY in el.string:
        results["found_in_dom"].append({
            "tag": el.name,
            "attr": "innerText",
            "value": el.string.strip()[:400]
        })

# 2) ابحث داخل <script> عن sitekey أو عن أنماط JSON قريبة من Turnstile
script_texts = [s.get_text() for s in soup.find_all("script")]
for idx, txt in enumerate(script_texts):
    if SITEKEY in txt:
        results["scripts_with_sitekey"].append({"script_index": idx, "snippet": txt[:800]})

# 3) محاولة إيجاد كائنات JSON-like تحوي كلمات مفتاحية متعلقة بـ Turnstile
combined_scripts = "\n".join(script_texts)
pattern = re.compile(
    r"\{[^{}]{0,1500}?(?:action|data|pagedata|turnstile|sitekey|cf-turnstile)[^{}]{0,1500}\}",
    re.IGNORECASE | re.DOTALL
)
for m in pattern.finditer(combined_scripts):
    raw = m.group(0)
    candidate = raw.replace("'", '"')
    candidate = re.sub(r",\s*}", "}", candidate)
    candidate = re.sub(r",\s*]", "]", candidate)
    parsed = None
    try:
        parsed = json.loads(candidate)
    except Exception:
        parsed = {"raw": raw[:1000]}
    results["json_like_matches"].append(parsed)

# طباعة النتائج باختصار
print("== DOM occurrences ==", len(results["found_in_dom"]))
for i, it in enumerate(results["found_in_dom"][:10], 1):
    print(f"{i}. <{it['tag']}> @{it['attr']} -> {it['value']}")

print("\n== Scripts containing sitekey ==", len(results["scripts_with_sitekey"]))
for s in results["scripts_with_sitekey"]:
    print("script index:", s["script_index"])
    print(s["snippet"][:500])
    print("----")

print("\n== JSON-like matches found ==", len(results["json_like_matches"]))
for j in results["json_like_matches"][:10]:
    print(j)
